/**
**vC[ǗNX
**2003.6.6
**Last Modified By M.Nakashizu--*/

package bou_n_sha.wana.control;

import bou_n_sha.wana.data.character.*;
import bou_n_sha.wana.data.item.*;
import bou_n_sha.wana.data.*;
import java.io.*;
import java.util.*;

public class PlayerControl implements SetItemInterface{
  private int           myCharacterID;
  private int           currentItemPos = 0;
  private String        characterName        = "߂";//eXgpɌ߂BivCj
  private String  		playerName           = "Mr.CB";//eXgpɌ߂BivC
  private String        poolCommand          =  ""; //R}hi[Ă
  private GameCharacter gc;
  private Room			currentRoom;
  private PortableItem  currentItem = null;
  private WanaClient	wanaClient;
  private Weapon        currentWeapon;
  private Weapon        defaultWeapon;
  //private HashMap     itemMap              = new HashMap();
  private ArrayList     itemList            = new ArrayList(9);
  private String        bufferKeyMessage = "";
  
  private int			playerScore = 0;
  /**
   * RXgN^
   * vC[gpLN^[Ə𐶐
   * @param	r	LN^[zu镔
   * @param	selectCharacter	vC[I񂾃LN^[ԍ
   * @param	objID	LN^[̃IuWFNgID
   * @param	x	GameCharacterXWʒu
   * @param	y	GameCharacterYWʒu
   * @param	wc	WanaClient
   * 
   */
	public PlayerControl(Room r,String pn,int selectCharacter,int objID,int x,int y,WanaClient wc){
      currentRoom = r;
      playerName = pn;
      wanaClient = wc;
	  
      createCharacter(objID,selectCharacter,x,y);
      int attackPoint = gc.getAttackPoint();
      createInitialWeapon(objID+1,attackPoint);
	  
	  playerScore = 0;
	  
      itemList.add(null);
    }
  
  /**
   * I΂ꂽԍɑGameCharacter̐
   * @param	objID	GameCharacter̃IuWFNgID
   * @param	selectCharacter	I΂ꂽLN^[̔ԍ
   * @param	x	GameCharacterXWʒu
   * @param	y	GameCharacterYWʒu
   */
  public void createCharacter(int objID,int selectCharacter,int x,int y){
    myCharacterID = objID;
    switch(selectCharacter){
    /*case 0:
      gc = new GreenMan(myCharacterID,"01",currentRoom);
      break;
    case 1:
      gc = new BlackMan(myCharacterID,"01",currentRoom);
      break;
    case 2:
      gc = new T_no(myCharacterID,"01",currentRoom);
      break;*/
    case 0:
      gc = new T_no(myCharacterID,"01",currentRoom);
      break;
	case 1:
      gc = new U_da(myCharacterID,"01",currentRoom);
      break;
    default:
      gc = new GreenMan(myCharacterID,"01",currentRoom);
      break;
    }

    gc.setWanaClient(wanaClient);
    gc.setInterface(this);
    characterName = gc.getCharacterName();
    
    currentRoom.addObject(gc,x,y);
  }
  
  /**
   * eXgp\bh
   * LN^[̏ifj̐
   */
  public void createInitialWeapon(int objID, int attackPoint){
    defaultWeapon = new Fist(objID,attackPoint,currentRoom);
    currentWeapon = defaultWeapon;
  }
  

/**
 *݂Room₢킹
 *@return ݂̕
 */
	public Room getCurrentRoom(){
		return currentRoom;
	}

  /**
    * ߂ĂL[̃bZ[W폜
    */
  public void clearBufferMessage(){
    bufferKeyMessage = "";
  }
  
/** 
 *w肵IuWFNgID̃IuWFNgɃbZ[W𑗂(H)
 *@param ObjID IuWFNgIDԍ
 *@param str 郁bZ[W
 */
  public void sendToGameObject(String keyMessage){
    if(gc.getStatus()==0){
      if(keyMessage.startsWith("MOVE_")){
        keyMessage = gc.catchPlayerMessage(keyMessage);
      }
      else if(keyMessage.equals("ATTACK")){
        keyMessage = currentWeapon.attackAction(gc);
      }
      else if(keyMessage.equals("ACTION")){
        if(currentItem instanceof Trap){
          GameObject go = gc.frontCheck();
          if(go!=null){
            keyMessage = ((Trap)currentItem).setTrapMessage(go,gc);
          }else{
            keyMessage="false";
          }
        }else{
          GameObject go=gc.frontCheck();
          if(go!=null && itemList.size()!=9){
            keyMessage = go.actionMessage(gc);
          }else if(go instanceof Weapon){
            keyMessage = go.actionMessage(gc);
          }else{
            keyMessage = "false";
          }
        }
      }else if(keyMessage.equals("ITEM_SELECT")){
        currentItemPos++;

        if(currentItemPos==9 || currentItemPos == itemList.size()) currentItemPos = 0;
        currentItem = (PortableItem)itemList.get(currentItemPos);
        wanaClient.repaintItemDisplay(); //
        keyMessage = "false";
      }
      
      if(!keyMessage.equals("false") && !keyMessage.equals(bufferKeyMessage)){
        sendToServer(keyMessage);
      }
      bufferKeyMessage = keyMessage;
    }
  }

/**
 *T[o[ɃbZ[W𑗂
 *@param str 郁bZ[W
 */
	public void sendToServer(String str){
//		wanaClient.sendMessage(str);
        poolCommand = poolCommand + str;
	}

	public void moveMyCharacter(String str){
		sendToGameObject(str);
	}

/**݂̃Q[LԂ
 *@return ݂̃Q[LN^[
 */
	public GameCharacter getGameCharacter(){
		return gc;
	}
/**
 *̃LN^[IDԂ܂
 *@return ̃LN^[ID
 */
	public int getObjectID(){
		return myCharacterID;
	}

/**
 *vC[̖OZbg܂B
 *@param str vC[̖O
 */
	public void setplayerName(String str){
	   playerName = str;
	}
/**
 *vC[̖OԂ܂B
 *@return vC[̖O
 */
	public String getplayerName(){
		return playerName;
	}

  /**
    *݂̃ACeZbg
    */
  public void setCurrentItem(GameObject item){
    currentItem = (Trap)item;
  }
  
/**
 *LN^[̖OZbg܂B
 *@param str LN^[̖O
 */
  public void setcharacterName(String str){
    characterName = str;
  }
  
/**
 *LN^[̖OԂ܂B
 *@return LN^[̖O
 */
	public String getcharacterName(){
		return characterName;
	}

/**
  * i[ĂR}hbZ[WԂ
  * @return R}hbZ[W
  */
  public String getCommand(){
    return poolCommand;
  }

 /**
  * i[ĂR}hbZ[W
  */
  public void clearCommand(){
    poolCommand = "";
  }

  /**
   * itemListԂ
   * @return	vC[ĂACẽXg
   */
  public ArrayList getItemList(){
    return itemList;
  }

  /**
    *ACëʒu擾
    */
  public int getCurrentItemPos(){
    return currentItemPos;
  }
  
/**
  * ArrayListɏĂACeǉ
  * @param objID ǉACẽIuWFNghc
  * @param item ACeIuWFNg
  */
	public void setItem(GameObject item){
      wanaClient.repaintItemDisplay(); //
      itemList.add(item);
	}

  /**
    *ACeXgACe폜
    */
  public void removeItem(){
    int i = itemList.indexOf(currentItem);
    itemList.remove(i);
    currentItemPos=0;
    currentItem = (PortableItem)itemList.get(currentItemPos);
    wanaClient.repaintItemDisplay(); //
  }

  /**
   * EACe𑕔
   */
  public void setCurrentWeapon(Weapon weapon){
  	wanaClient.repaintItemDisplay(); //
    currentWeapon = weapon;
  }

  /**
   * ̃ACeɖ߂
   */
  public void setDefaultWeapon(){
    wanaClient.repaintItemDisplay();
    currentWeapon = defaultWeapon;
  }
  
/**
 *ݎĂ镐Ԃ
 *@return 
 */
  public Weapon getCurrentWeapon(){
    return currentWeapon;
  }

  /**
   * 
   */
  public void setScore(int score){
  	playerScore = score;
  }
  
  /**
   * 
   */
   public int getScore(){
   	return playerScore;
   }

/**
 *HashMapɏĂACeQƂ
 *
 */
	/*public GameObject getItem(int objID){
	   	GameObject gObj = (GameObject)itemList.get(new Integer(objID));
		return gObj;
	}*/
}
