//==========================================//
//			VT[o[䕔	 Ver1.5	//
//				2003/06/10					//
//		Last Modified By Kushibiki   		//
//==========================================//
package bou_n_sha.wana.control;

import bou_n_sha.network.*;
import bou_n_sha.wana.data.*;
import bou_n_sha.wana.data.character.*;
import bou_n_sha.wana.data.item.*;
import bou_n_sha.wana.data.room.*;
import java.util.*;

/**
 * T[o[䕔
 */
public class WanaServer implements ServerControler{
  
  private SocketServer soc;
  private int          objectIDCounter = 0;
  private String       playerNameList[] = new String[8];
  private int          playerObjIDList[] = new int[8];
  private int		   playerScoreList[] = new int[8];
  private HashMap      countList = new HashMap();
  private String       poolMessage = "";
  private String       clientMessage = "";
  private RoomMap      roomMap;
  private PlayerItemList playerItem;
  
  private ServerCommandDistribute serverCommandDistribute; //eXg
  
  /**
   * ڑ\ȍőNCAgi	Wj
   */
  static final public int maxClient = 8;//ڑ\ȍőNCAg
  
  /**
   * WanaServerRXgN^
   */
  public WanaServer(){
    Arrays.fill(playerObjIDList,-1);
    Arrays.fill(playerNameList,"");
	Arrays.fill(playerScoreList,0);
    serverCommandDistribute = new ServerCommandDistribute(this);
    roomMap = new RoomMap(1);
    
    //eXgpɃACe\
    Weapon t_no_bou = new Blade(objectIDCounter++,roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)t_no_bou,9,5);
    
    //eXgpɃACe\
    Weapon t_no_bou2= new Blade(objectIDCounter++,roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)t_no_bou2,4,3);
	
    //eXgpɃACe\
    Weapon t_no_bou3= new Blade(objectIDCounter++,null);
    
    Weapon t_no_bou4= new Blade(objectIDCounter++,null);

    //eXgp㩂zu
    Trap t_no_bomb=new Bomb(objectIDCounter++,roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)t_no_bomb,4,10);
    
    //eXgp㩂zu
    Trap t_no_bomb1=new Bomb(objectIDCounter++,roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)t_no_bomb1,4,2);

    //eXgp㩂zu
    Trap t_no_bomb2=new Bomb(objectIDCounter++,roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)t_no_bomb2,6,3);

    //eXgp㩂zu
    Trap t_no_bomb3=new Bomb(objectIDCounter++,roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)t_no_bomb3,9,10);
    
     //eXgp㩂zu
    Trap t_no_bomb4=new Bomb(objectIDCounter++,null);

     //eXgp㩂zu
    Trap t_no_bomb5=new Bomb(objectIDCounter++,null);

    //[IuWFNgeXgpɕ\
    RoomObject tana = new Box(objectIDCounter++,"00",roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)tana,1,1);
    tana.setItemFlag((PortableItem)t_no_bomb4);

    //[IuWFNgeXgpɕ\
    RoomObject tana1 = new Box(objectIDCounter++,"00",roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)tana1,3,6);
    tana1.setItemFlag((PortableItem)t_no_bomb5);

     //[IuWFNgeXgpɕ\
    RoomObject tana2 = new Box(objectIDCounter++,"00",roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)tana2,1,8);

    //[IuWFNgeXgpɕ\
    //RoomObject tana3 = new Box(objectIDCounter++,"00",roomMap.getRoom(0));
    //roomMap.getRoom(0).addObject((GameObject)tana3,4,1);

    //[IuWFNgeXgpɕ\
    RoomObject tana4 = new Box(objectIDCounter++,"00",roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)tana4,5,1);


    //[IuWFNgeXgpɕ\
    RoomObject tana5 = new Box(objectIDCounter++,"00",roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)tana5,6,1);


    //[IuWFNgeXgpɕ\
    RoomObject tana6 = new Box(objectIDCounter++,"00",roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)tana6,7,1);
    tana6.setItemFlag((PortableItem)t_no_bou4);


    //[IuWFNgeXgpɕ\
    //RoomObject tana7 = new Box(objectIDCounter++,"00",roomMap.getRoom(0));
    //roomMap.getRoom(0).addObject((GameObject)tana7,8,1);

    //[IuWFNgeXgpɕ\
    RoomObject tana8 = new Box(objectIDCounter++,"01",roomMap.getRoom(0));
    roomMap.getRoom(0).addObject((GameObject)tana8,9,1);
    tana8.setItemFlag((PortableItem)t_no_bou3);

    playerItem = new PlayerItemList();
  }
  
  /**
   * WanaServermain
   */
  public static void main(String[] args){
    System.out.println("SystemMsg: T[o{̋N");
    SocketServer 	ss = new SocketServer();
    WanaServer	ws = new WanaServer();
    ss.setServerControler(ws);
    ws.setSocketServer(ss);
    GameClock g = new GameClock(ss,ws);
    
  }
  
  /**
   * \PbgT[õC^[tFCXZbg
   * @param mss \PbgT[o[
   */
  public void setSocketServer(SocketServer mss){
    soc = mss;
  }
  
  /**
   * NCAg̃bZ[W1bZ[WƂɕ
   * @param id RlNVID
   * @param str bZ[W
   */
  public synchronized void receiveMessage(int connectionID,String str){
    clientMessage = str;
    while(!clientMessage.equals("")){
      int len = 0;
      try{
        len = WanaNetworkProtcol.TOTAL_MSG4 + Integer.parseInt(clientMessage.substring(WanaNetworkProtcol.TOTAL_MSG3,WanaNetworkProtcol.TOTAL_MSG4),36);

      }catch(NullPointerException e){
        e.printStackTrace();
      }
      
      serverCommandDistribute.setMessageQueue(connectionID + clientMessage.substring(0,len)); //L[Ɋi[
      clientMessage = clientMessage.substring(len);
    }
  }
  
  /**
   * NCAgVKɎQĂƂĂ΂郁\bh
   * @param id RlNVhc
   * @param str ߃bZ[W
   */
  public void receiveStart(int connectionID , int selectCharacter , String pn){
    String sendMessage = "";
//  String strSelectChara = WanaUtil.normalization(selectCharacter,WanaNetworkProtcol.INDEX_NUMBER);
    String playerName = pn;
    
    int tmpID = connectionID-1;
    
    //T[o[߂l
    int objectID =objectIDCounter++;

    //objectIDCounter++ = objectID + 1;//fACep̃IuWFNgID
    String strObjectID = WanaUtil.normalization(objectID,WanaNetworkProtcol.OBJ_NUMBER);

    //܂镔Əꏊݒ
    String strRoomNum = "00";
    String strX = "05";
    String strY = "05";

    //VKɎQĂNCAg̃vC[ƃLN^[̃IuWFNgIDێ
    playerNameList[tmpID] = "";
    playerNameList[tmpID] = playerName;
    playerObjIDList[tmpID] = objectID;

    //VKɎQĂNCAg̃LN^[̍쐬
    Room currentRoom = roomMap.getRoom(Integer.parseInt(strRoomNum,36));
    GameObject object=null;
    switch(selectCharacter){
    /*case 0:
      object = new GreenMan(objectID,"01",currentRoom);
      break;
    case 1:
      object = new BlackMan(objectID,"01",currentRoom);
      break;
    case 2:
      object = new T_no(objectID,"01",currentRoom);
      break;*/
      
    case 0:
      object = new T_no(objectID,"01",currentRoom);
      break;
	case 1:
      object = new U_da(objectID,"01",currentRoom);
      break;
    default:
      object = new GreenMan(objectID,"01",currentRoom);
      break;
    }
    
    currentRoom.addObject(object,Integer.parseInt(strX,36),Integer.parseInt(strY,36));
    object = new Fist(objectIDCounter++,((GameCharacter)object).getAttackPoint(),currentRoom);
    playerItem.addItem(object);
    
    sendMessage = WanaNetworkProtcol.START + strRoomNum + strObjectID + "004" + strX + strY;
    soc.sendTo(connectionID,sendMessage);
    sendMessage = "";

    //Q[ɂSẴIuWFNgVKɎQĂNCAgɒm点
    ListIterator itr = currentRoom.getGameObjectList().listIterator();
    while( itr.hasNext() ){
      GameObject gObjTmp = (GameObject)itr.next();

      if(objectID != gObjTmp.getObjectID()){
        String tmpObjID = WanaUtil.normalization(gObjTmp.getObjectID(),WanaNetworkProtcol.OBJ_NUMBER);
        //String tmpIndexNum = WanaUtil.normalization(gObjTmp.getImageKey(),WanaNetworkProtcol.INDEX_NUMBER);
        String tmpX = WanaUtil.normalization(gObjTmp.getX(),2);
        String tmpY = WanaUtil.normalization(gObjTmp.getY(),2);
        if(gObjTmp instanceof GameCharacter){
          int tmp = gObjTmp.getObjectID();
          String otherPlayerName = playerNameList[WanaUtil.arraySearch(playerObjIDList,tmp)];
          String strLen = WanaUtil.normalization((9 + otherPlayerName.length()),WanaNetworkProtcol.MSG_NUMBER);
          String tmpImageKey = gObjTmp.getImageKey().substring(5);
		  sendMessage = sendMessage + WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + tmpObjID + strLen + WanaNetworkProtcol.OBJ_CHARACTER + tmpImageKey + tmpX + tmpY + otherPlayerName;
		  
		  String strScore = WanaUtil.normalization(playerScoreList[WanaUtil.arraySearch(playerObjIDList,tmp)],3);
		  sendMessage = sendMessage + WanaNetworkProtcol.CONTROL + strRoomNum + tmpObjID + "005" + WanaNetworkProtcol.ACT_SCORE + strScore;
        }else if(gObjTmp instanceof Item){
          String tmpImageKey = gObjTmp.getImageKey().substring(4);
          sendMessage  = sendMessage + (WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + tmpObjID + "009" + WanaNetworkProtcol.OBJ_ITEM + tmpImageKey + tmpX + tmpY);

          Trap trap = gObjTmp.getTrapObject();
          //ACe㩂d|ĂꍇANCAgɂd|
          if(trap != null){
            String itemImageKey = trap.getImageKey().substring(4);
            String strItemID = WanaUtil.normalization(trap.getObjectID(),3);
            String strRoomObjectID = WanaUtil.normalization(gObjTmp.getObjectID(),3);
            sendMessage = sendMessage + (WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + strItemID + "00c" + WanaNetworkProtcol.OBJ_SETTRAP + itemImageKey + tmpX + tmpY + strRoomObjectID);
          }
        }else if(gObjTmp instanceof RoomObject){
          String tmpImageKey = gObjTmp.getImageKey().substring(4);

          sendMessage = sendMessage + (WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + tmpObjID + "009" + WanaNetworkProtcol.OBJ_ROOM + tmpImageKey + tmpX + tmpY);

          //[IuWFNg̒ɉĂ炻NCAgɒm点
          PortableItem item = ((RoomObject)gObjTmp).getItemFlag();
          if(item!=null){
            String itemImageKey = item.getImageKey().substring(4);
            String strItemID = WanaUtil.normalization(item.getObjectID(),3);
            String strRoomObjectID = WanaUtil.normalization(gObjTmp.getObjectID(),3);
            sendMessage = sendMessage + (WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + strItemID + "00c" + WanaNetworkProtcol.OBJ_ROOMITEM + itemImageKey + tmpX + tmpY + strRoomObjectID);
          }

          //[IuWFNg̒㩂d|ĂNCAgɒm点
          Trap trap = gObjTmp.getTrapObject();
          if(trap != null){
            String itemImageKey = trap.getImageKey().substring(4);
            String strItemID = WanaUtil.normalization(trap.getObjectID(),3);
            String strRoomObjectID = WanaUtil.normalization(gObjTmp.getObjectID(),3);
            sendMessage = sendMessage + (WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + strItemID + "00c" + WanaNetworkProtcol.OBJ_SETTRAP + itemImageKey + tmpX + tmpY + strRoomObjectID);
          }
        }
      }
    }
    soc.sendTo(connectionID,sendMessage);

    System.out.println("Jn" + sendMessage);
    //VKɎQĂNCAg̃LN^[ݎQĂNCAgɒm点
    String strLen = WanaUtil.normalization(WanaNetworkProtcol.TOTAL_MSG4 + playerName.length(),WanaNetworkProtcol.MSG_NUMBER);
    sendMessage  = WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + strObjectID + strLen + WanaNetworkProtcol.OBJ_CHARACTER + selectCharacter + "-01"  + strX + strY + playerName;
    poolMessage = poolMessage + sendMessage;
  }
  
  /**
   * NCAgɐؒfꂽƂɁAT[o[LN^[폜
   * @param	connectionID	ڑID
   * @param	roomNum	ؒfɂԍ
   * @param	objectID	gpĂLN^[̃IuWFNgID
   */
  public void receiveEnd(int connectionID,int roomNum ,int objectID){
    String strRoomNum = WanaUtil.normalization(roomNum,WanaNetworkProtcol.ROOM_NUMBER);
    String strObjectID = WanaUtil.normalization(objectID,WanaNetworkProtcol.OBJ_NUMBER);

    roomMap.getRoom(roomNum).removeObject(objectID);
    
    soc.disconnect(connectionID);
    
    soc.broadcast(WanaNetworkProtcol.END + strRoomNum + strObjectID + "000");
  }

/**
  * NCAgُɐؒfꂽƂɁAT[o[LN^폜
  * @param connectionID ؒfꂽNCAg̐ڑID
  */
  public void removePlayerCharacter(int connectionID){
    int roomNum;
    connectionID--;
    int objectID = playerObjIDList[connectionID];
    
    for(roomNum = 0;roomNum<1;roomNum++){
      Room room = roomMap.getRoom(roomNum);
      GameObject gameObject =  room.callObject(objectID);
      if(gameObject != null){
        room.removeObject(objectID);
        String strRoomNum = WanaUtil.normalization(roomNum,WanaNetworkProtcol.ROOM_NUMBER);
        String strObjectID = WanaUtil.normalization(objectID,WanaNetworkProtcol.OBJ_NUMBER);
        
        soc.broadcast(WanaNetworkProtcol.END + strRoomNum + strObjectID + "000");
        break;
      }
    }
  }
  
  /**
   * NCAgRg[bZ[W󂯎ɎsB
   * @param connectionID RlNVID
   * @param roomNum ԍ
   * @param objectID IuWFNgID
   * @param command R}h
   */
  public void receiveControl(int connectionID,int roomNum,int objectID,String command){

    String strCommand = command.substring(0,WanaNetworkProtcol.ACT_NUMBER);

    if(strCommand.equals(WanaNetworkProtcol.ACT_MOVE)){
      move(roomNum,objectID,command);
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_DIRECTION)){
      move(roomNum,objectID,command);
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_ATTACK)){
      attack(roomNum,objectID,command);
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_PICK)){
      pickup(roomNum,objectID,command);
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_SEARCH)){
      search(connectionID,roomNum,objectID,command);
    }else if(strCommand.equals(WanaNetworkProtcol.ACT_SETTRAP)){
      setTrap(connectionID,roomNum,objectID,command);
    }
  }
  
  /**
   * `bgꍇ̏
   * @param id RlNVID
   * @param chatMessage bZ[W
   */
  public void receiveChat(int connectionID,String chatMessage){
    try{
      int tmpID = connectionID - 1;
      
      // bZ[WH(vύX)
      chatMessage = playerNameList[tmpID] + "F" + chatMessage;
      String strLen = WanaUtil.normalization(chatMessage.length(),3);
      chatMessage = WanaNetworkProtcol.CHAT + "00000" + strLen + chatMessage;
      
      soc.broadcast(chatMessage);
    }
    catch(Exception e){
      System.out.println("`bg̕Ɏs܂.");
      e.printStackTrace();
    }
  }

  /**
   * IuWFNgړ
   * @param roomNum ԍ
   * @param objectID IuWFNgID
   * @param command R}h
   */
  public void move(int roomNum, int objectID, String command){
    String strRoomNum = WanaUtil.normalization(roomNum,WanaNetworkProtcol.ROOM_NUMBER);
    String strObjectID = WanaUtil.normalization(objectID,WanaNetworkProtcol.OBJ_NUMBER);
    String strLen = WanaUtil.normalization(command.length(),WanaNetworkProtcol.MSG_NUMBER);
    roomMap.getRoom(roomNum).callObject(objectID,command);
    
    poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strObjectID + strLen + command;
  }
  
  /**
   * U
   * @param roomNum ԍ
   * @param objectID IuWFNgID
   * @param command R}h
   */
  public void attack(int roomNum, int objectID ,String command){
    Room currentRoom = roomMap.getRoom(roomNum);
    GameObject gameObject = currentRoom.callObject(objectID);

    if(gameObject instanceof GameCharacter && ((GameCharacter)gameObject).getStatus()!=1){
      GameCharacter hitObject = (GameCharacter)gameObject;
      int weaponID = Integer.parseInt(command.substring(WanaNetworkProtcol.ACT_NUMBER,WanaNetworkProtcol.ACT_NUMBER+WanaNetworkProtcol.OBJ_NUMBER),36);
      GameCharacter attacker = (GameCharacter)currentRoom.callObject(Integer.parseInt(command.substring(WanaNetworkProtcol.ACT_NUMBER+WanaNetworkProtcol.OBJ_NUMBER),36));
      Weapon weapon = playerItem.callWeaponItem(weaponID);
      int offensePoint = attacker.getAttackPoint();
	  
      
      //SȊO͓̎̕S{̍̕U
      if(!(weapon instanceof Fist)) offensePoint = offensePoint + playerItem.callWeaponItem(weaponID).getOffensePoint();
      
      command = WanaNetworkProtcol.ACT_ATTACK + WanaUtil.normalization(offensePoint,4);
      currentRoom.callObject(objectID,command);
      
      String strRoomNum = WanaUtil.normalization(roomNum,WanaNetworkProtcol.ROOM_NUMBER);
      String strObjectID = WanaUtil.normalization(objectID,WanaNetworkProtcol.OBJ_NUMBER);

      attacker.setStatus(3);
	  int attackerID = attacker.getObjectID();
	  String strAttackerID = WanaUtil.normalization(attackerID,WanaNetworkProtcol.OBJ_NUMBER);
	  poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strAttackerID + "003" + WanaNetworkProtcol.ACT_STAT + "3";
      
	  int playerScore = playerScoreList[WanaUtil.arraySearch(playerObjIDList,attackerID)] + weapon.getScore();
	  String strScore = WanaUtil.normalization(playerScore,3);
	  playerScoreList[WanaUtil.arraySearch(playerObjIDList,attackerID)] = playerScore;
	  poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strAttackerID + "005" + WanaNetworkProtcol.ACT_SCORE + strScore;
      
      if(0 >= hitObject.getHitPoint()){
        hitObject.setStatus(1);
        countList.put(new Integer(hitObject.getObjectID()),hitObject);

        poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strObjectID + "003" + WanaNetworkProtcol.ACT_STAT + "1";
      } else {
        String strCommand = WanaNetworkProtcol.ACT_SETHP + WanaUtil.normalization(hitObject.getHitPoint(),3);
	    String strLen = WanaUtil.normalization(strCommand.length(),WanaNetworkProtcol.MSG_NUMBER);

        poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strObjectID + strLen + strCommand;
        poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strObjectID + "003" + WanaNetworkProtcol.ACT_STAT + "2";
      }
    }
  }

   /**
   * ACeE
   * @param roomNum ԍ
   * @param objectID EACẽIuWFNgID
   * @param command R}h
   */
  public void pickup(int roomNum, int objectID, String command){
    PortableItem portableItem = (PortableItem)(roomMap.getRoom(roomNum)).callObject(objectID);

    if(portableItem !=null){
      if(!checkTrap(roomNum,(GameObject)portableItem)){
        String strRoomNum = WanaUtil.normalization(roomNum,WanaNetworkProtcol.ROOM_NUMBER);
        String strObjectID = WanaUtil.normalization(portableItem.getObjectID(),WanaNetworkProtcol.OBJ_NUMBER);
        String strLen = WanaUtil.normalization(command.length(),WanaNetworkProtcol.MSG_NUMBER);

        poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strObjectID + strLen + command;

        PortableItem item = (PortableItem)portableItem.clone();
        item.setObjectID(objectIDCounter++);
        countList.put(new Integer(item.getObjectID()),item);

        portableItem.setCurrentRoom(null);
        playerItem.addItem(portableItem);
        roomMap.getRoom(roomNum).removeObject(portableItem.getObjectID());
      }
    }
  }

/**
  *[IuWFNg𒲂ׂ
  * @param roomNum ԍ
  * @param objectID IuWFNgID
  * @param command R}h
  */
  public void search(int connectionID,int roomNum,int objectID,String command){

    RoomObject roomObject = (RoomObject)(roomMap.getRoom(roomNum)).callObject(objectID);

    if(!checkTrap(roomNum,(GameObject)roomObject)){
      PortableItem portableItem = roomObject.getItemFlag();

      if(portableItem != null){
        playerItem.addItem(portableItem);

        String strRoomNum = WanaUtil.normalization(roomNum,WanaNetworkProtcol.ROOM_NUMBER);
        String strObjectID = WanaUtil.normalization(objectID,WanaNetworkProtcol.OBJ_NUMBER);
        command = WanaNetworkProtcol.ACT_PICK + command.substring(WanaNetworkProtcol.ACT_NUMBER);
        String strLen = WanaUtil.normalization(command.length(),WanaNetworkProtcol.MSG_NUMBER);

        poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strObjectID + strLen + command;

        roomObject.setItemFlag(null);

        PortableItem item = (PortableItem)portableItem.clone();
        item.setCurrentRoom(roomObject.getCurrentRoom());
        item.setObjectID(objectIDCounter++);
        item.setRoomObjectID(roomObject.getObjectID());
        countList.put(new Integer(item.getObjectID()),item);
      }
    }
  }

/**
  *㩂d|
  * @param roomNum ԍ
  * @param objectID IuWFNgID
  * @param command R}h
  */
  public void setTrap(int connectionID,int roomNum,int objectID,String command){
    String strCommand = command.substring(WanaNetworkProtcol.ACT_NUMBER,WanaNetworkProtcol.ACT_NUMBER+WanaNetworkProtcol.OBJ_NUMBER);
    Trap trap = playerItem.callTrapItem(Integer.parseInt(strCommand,36));
    GameObject gameObject = roomMap.getRoom(roomNum).callObject(objectID);
    
	if(gameObject !=null && (!checkTrap(roomNum,gameObject))){
      gameObject.setTrapObject(trap);
      String sendMessage =  WanaNetworkProtcol.CONTROL_PC + "00000000";
      playerItem.removeItem(Integer.parseInt(strCommand,36));
      soc.sendTo(connectionID,sendMessage);

	  String strRoomNum = WanaUtil.normalization(roomNum,WanaNetworkProtcol.ROOM_NUMBER);
      String strItemID = WanaUtil.normalization(trap.getObjectID(),WanaNetworkProtcol.OBJ_NUMBER);
      String itemImageKey = trap.getImageKey().substring(4);
      String strRoomObjectID = WanaUtil.normalization(objectID,WanaNetworkProtcol.OBJ_NUMBER);
      trap.setCharacterID(Integer.parseInt(command.substring(WanaNetworkProtcol.ACT_NUMBER+WanaNetworkProtcol.OBJ_NUMBER),36));
      
	  poolMessage = poolMessage + (WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + strItemID + "00c" + WanaNetworkProtcol.OBJ_SETTRAP + itemImageKey + "00" + "00" + strRoomObjectID);
	}
  }

/**
  * 㩂d|Ă邩`FbN
  * @param roomNum ԍ
  * @param gameObject Q[IuWFNg
  * @return 㩂trueAȂfalse
  */
  public boolean checkTrap(int roomNum,GameObject gameObject){
    //GameObject gameObject = roomMap.getRoom(roomNum).callObject(objectID);
    Trap trap = gameObject.getTrapObject();
    String strRoomNum = WanaUtil.normalization(roomNum,WanaNetworkProtcol.ROOM_NUMBER);
    
    if(trap!=null){
      String strGameObject = WanaUtil.normalization(gameObject.getObjectID(),WanaNetworkProtcol.OBJ_NUMBER);
      poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strGameObject + "002" + WanaNetworkProtcol.ACT_TRAP_ANIM;

      GameCharacter[] hitCharacter = trap.fireAction(gameObject);
	  
      int i=0,j=0;
      while(hitCharacter[i]!=null){
        hitCharacter[i].setStatus(1);
        countList.put(new Integer(hitCharacter[i].getObjectID()),hitCharacter[i]);
        if(hitCharacter[i].getObjectID() != trap.getCharacterID()){
			j++;
        }
		
		String strObjectID = WanaUtil.normalization(hitCharacter[i].getObjectID(),WanaNetworkProtcol.OBJ_NUMBER);
        poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strObjectID + "003" + WanaNetworkProtcol.ACT_STAT + "1";
        i++;
      }
	  int setterID = trap.getCharacterID();
	  int playerScore = playerScoreList[WanaUtil.arraySearch(playerObjIDList,setterID)] + (trap.getScore() * j);
	  playerScoreList[WanaUtil.arraySearch(playerObjIDList,setterID)] = playerScore;
	  String strSetterID = WanaUtil.normalization(setterID,WanaNetworkProtcol.OBJ_NUMBER);
	  String strScore = WanaUtil.normalization(playerScore,3);
	  poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strSetterID + "005" + WanaNetworkProtcol.ACT_SCORE + strScore;
	  
	  gameObject.setTrapObject(null);
      playerItem.removeItem(trap.getObjectID());
      return true;
    }else{
      return false;
    }
  }
  
  /**
   * eʂi[bZ[W擾B
   * @return bZ[W
   */
  public String getPoolMessage(){
    return poolMessage;
  }
  
  /**
   * i[Ă郁bZ[WɂB
   */
  public void clearPoolMessage(){
    poolMessage = "";
  }
  
  /**
    *GameClockNXQ[NbN󂯎
    */
  public synchronized void catchClock(){
    
    if(!countList.isEmpty()){
      GameObject gameObject;
      Set set = countList.entrySet();
      Iterator itr = set.iterator();

      String gameObjectID="";
      
      while(itr.hasNext()){
        Map.Entry entry = (Map.Entry)itr.next();
        gameObject = (GameObject)entry.getValue();
        if(gameObject.clockCount()==0){
          gameObjectID=gameObjectID + WanaUtil.normalization(gameObject.getObjectID(),3);
        }
      }

      while(!gameObjectID.equals("")){
        GameObject go;
        int intID;

        intID=Integer.parseInt(gameObjectID.substring(0,3),36);
        
        go = (GameObject)countList.get(new Integer(intID));

        String strRoomNum = WanaUtil.normalization(go.getCurrentRoom().getRoomID(),WanaNetworkProtcol.ROOM_NUMBER);
        String strObjectID = WanaUtil.normalization(go.getObjectID(),WanaNetworkProtcol.OBJ_NUMBER);
        
        if(go instanceof GameCharacter){
          ((GameCharacter)go).setStatus(0);
          poolMessage = poolMessage + WanaNetworkProtcol.CONTROL + strRoomNum + strObjectID + "003" + WanaNetworkProtcol.ACT_STAT + "0";
          
        }else if(go instanceof PortableItem){
          String tmpImageKey = go.getImageKey().substring(4);
          String tmpX = WanaUtil.normalization(go.getX(),2);
          String tmpY = WanaUtil.normalization(go.getY(),2);

          if(((PortableItem)go).getRoomObjectID() == -1){
            go.getCurrentRoom().addObject(go,go.getX(),go.getY());
            poolMessage  = poolMessage + (WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + strObjectID + "009" + WanaNetworkProtcol.OBJ_ITEM + tmpImageKey + tmpX + tmpY);
          }else{
            Room r = go.getCurrentRoom();
            RoomObject ro = (RoomObject)r.callObject(((PortableItem)go).getRoomObjectID());
            ro.setItemFlag((PortableItem)go);

            String strRoomObjectID = WanaUtil.normalization(((PortableItem)go).getRoomObjectID(),WanaNetworkProtcol.OBJ_NUMBER);

            poolMessage = poolMessage + (WanaNetworkProtcol.MAKE_OBJECT + strRoomNum + strObjectID + "00c" + WanaNetworkProtcol.OBJ_ROOMITEM + tmpImageKey + tmpX + tmpY + strRoomObjectID);
          }
        }
        countList.remove(new Integer(intID));
        gameObjectID = gameObjectID.substring(3);
      }
    }
  }
}

/**
  *vC[ĂACẽXg
  */
class PlayerItemList{

  private HashMap playerItemMap;
  
  /**
   * RXgN^
   * vC[ĂACeHashMap𐶐
   */
  public PlayerItemList(){
    playerItemMap = new HashMap();
  }

  /**
   * ACeǉB
   * @param gameObject ǉQ[IuWFNg
   */
  public void addItem(GameObject gameObject){
    playerItemMap.put(new Integer(gameObject.getObjectID()),gameObject);
  }

  /**
   * ACe폜B
   * ACe̎gp񐔂0ɂȂÂĂꂽɌĂяoB
   * @param objectID IuWFNgID
   */
  public void removeItem(int objectID){
    playerItemMap.remove(new Integer(objectID));
  }

  /**
   * ACěĂяo
   * @param objectID IuWFNgID
   * @return w肳ꂽACe
   */
  public Weapon callWeaponItem(int objectID){
    Weapon 	weapon 	= null;
    if(playerItemMap.get(new Integer(objectID)) instanceof Weapon){
      weapon = (Weapon)playerItemMap.get(new Integer(objectID));
    }else{
      System.out.println(objectID + "̕ACe݂͑܂");
    }
	  return weapon;
    
  }

/**
 * ȊȌACěĂяo
 * @param objectID 	ĂяoACẽIuWFNghc
 * @return	ACeIuWFNgi݂㩃ACẽIuWFNgj
 */
  public Trap callTrapItem(int objectID){
    Trap trap = null;

   if(playerItemMap.get(new Integer(objectID)) instanceof Trap){
     trap = (Trap)playerItemMap.get(new Integer(objectID));
     //removeItem(objectID);
    }else{
      System.out.println(objectID + "㩃ACe݂͑܂");
    }
    return trap;
  }
}

/**
 *Q[NbNp̃NX
 */
class GameClock extends Thread{
  
  SocketServer soc;
  WanaServer   wanaServer;
  
  /**
   * GameClock̃RXgN^
   * @param ss SocketServer̃CX^X
   * @param ws WanaServer̃CX^X
   */
  GameClock(SocketServer ss ,WanaServer ws){
    soc = ss;
    wanaServer = ws;
    this.start();
  }
  
  /**
   * ԊuƂɏʂƃQ[NbNNCAgɑB
   */
  public void run(){
    while(true){
      try{
        if(!wanaServer.getPoolMessage().equals("")){
          soc.broadcast(wanaServer.getPoolMessage());
          System.out.println("MbZ[W"+wanaServer.getPoolMessage());
          wanaServer.clearPoolMessage();
        }
        Thread.sleep(33);
        soc.broadcast(String.valueOf(WanaNetworkProtcol.GAME_CLOCK));
        wanaServer.catchClock();
      }catch(InterruptedException e){}
    }
  }
}

/**
  * NCAg̃bZ[WeR}hʂɎd
  */
class ServerCommandDistribute extends Thread{
  
  String message = "";
  String command = "";
  int connectionID;
  int objectID;
  int roomNum;
  Vector messageQueue = new Vector();
  Vector controlMessageQueue = new Vector();
  WanaServer wanaServer;

  ServerControlProcessing controlProcessing1;
  ServerControlProcessing controlProcessing2;
  ServerControlProcessing controlProcessing3;
  ServerControlProcessing controlProcessing4;
  ServerControlProcessing controlProcessing5;
  
/**
  *RXgN^
  */
  ServerCommandDistribute(WanaServer ws){
    super("CommandDistribute");
    wanaServer = ws;
        
    controlProcessing1 = new ServerControlProcessing(1,wanaServer);
    controlProcessing2 = new ServerControlProcessing(2,wanaServer);
    controlProcessing3 = new ServerControlProcessing(3,wanaServer);
    controlProcessing4 = new ServerControlProcessing(4,wanaServer);
    controlProcessing5 = new ServerControlProcessing(5,wanaServer);
    
    this.start();
  }
  
  /**
   * bZ[W𔻕ʂāAsNXƂɎdB
   * messageQueueɉi[ĂȂwaitԂƂȂB
   */
  public void run(){
    while(true){
      try{
        synchronized(this){
          while(messageQueue.isEmpty()){
            wait();
          }
        }
        message = (String)messageQueue.firstElement();
        connectionID = Integer.parseInt(message.substring(0,1));
        message = message.substring(1);
        commandDivision(message);
        
        switch(message.charAt(0)){
        case WanaNetworkProtcol.START:
          wanaServer.receiveStart(connectionID,objectID,command);
          break;
        case WanaNetworkProtcol.END:
          wanaServer.receiveEnd(connectionID,roomNum,objectID);
          break;
        case WanaNetworkProtcol.MAKE_OBJECT: //
          break;
        case WanaNetworkProtcol.CONTROL:
          this.controlProcessingManeger(connectionID,roomNum,objectID,command);
          break;
        case WanaNetworkProtcol.CHAT:
          wanaServer.receiveChat(connectionID,command);
          break;
        default:
          break;
        }
        messageQueue.remove(0);
        
      }catch(InterruptedException e){}
    }
  }
  
/**
 * L[ɃbZ[Wi[AwaitԂnotifyԂɂ
 * @param str bZ[W
 */
  synchronized public void setMessageQueue(String str){
    messageQueue.addElement(str);
    notify();
  }

/**
 * Rg[NX̊ǗsB()
 */
  public void controlProcessingManeger(int connectionID,int rn, int objID, String com){
    if(controlProcessing1.getFlg()==true){
      controlProcessing1.setCommand(connectionID,rn,objID,com);
    }else if(controlProcessing2.getFlg()==true){
      controlProcessing2.setCommand(connectionID,rn,objID,com);
    }else if(controlProcessing3.getFlg()==true){
      controlProcessing3.setCommand(connectionID,rn,objID,com);
    }else if(controlProcessing4.getFlg()==true){
      controlProcessing4.setCommand(connectionID,rn,objID,com);
    }else if(controlProcessing5.getFlg()==true){
      controlProcessing5.setCommand(connectionID,rn,objID,com);
    }else{
//      controlMessageQueue.addElement(rn);
//      controlMessageQueue.addElement(new String(obj));
//      controlMessageQueue.addElement(com);
    }
  }

/**
  * T[o炫bZ[W𕪊A
  * ԍAIuWFNgIDAߕ擾B
  * @param str T[o[̃bZ[W
  */
  private void commandDivision(String str){
    try{
      //IuWFNgNoƃbZ[W̌o
      roomNum = Integer.parseInt((str.substring(WanaNetworkProtcol.CNT_NUMBER,WanaNetworkProtcol.TOTAL_MSG2)),36);
      objectID = Integer.parseInt((str.substring(WanaNetworkProtcol.TOTAL_MSG2,WanaNetworkProtcol.TOTAL_MSG3)),36);
      command = str.substring(WanaNetworkProtcol.TOTAL_MSG4);
    }
    catch(Exception e){
      e.printStackTrace();
    }
  }
}

/**
  * Rg[bZ[WNX
  */
class ServerControlProcessing extends Thread{
  
  String     command = "";
  boolean    flg = true;
  int        roomNum;
  int        objectID;
  int        connectionID;
  
  WanaServer wanaServer;
  
  /**
   * RXgN^
   * @param threadNum Xbhԍ
   * @param ws WanaServer̃CX^X
   */
  public ServerControlProcessing(int threadNum,WanaServer ws){
    super("CProcessing"+threadNum);
    wanaServer =ws;
    this.start();
  }
  
  /**
   * Rg[bZ[W̏sBĂȂwaitԂƂȂB
   */
  public void run(){
    while(true){
      try{
        synchronized(this){
          while(flg){
            wait();
          }
        }
        wanaServer.receiveControl(connectionID,roomNum,objectID,command);
        flg = true;
      }catch(Exception e){
        e.printStackTrace();
        //System.out.println(e.printStackTrace());
      }
    }
  }
  
  /**
   * receiveControlɕKvȂ̂ݒ肷B
   * @param rn ԍ
   * @param objID IuWFNgID
   * @param str R}h
   */
  synchronized public void setCommand(int cID,int rn ,int objID, String str){
    roomNum = rn;
    objectID = objID;
    command = str;
    connectionID=cID;
    flg = false;
    notify();
  }
  
  /**
   * ݂̃Xbhғҋ@Ԃ
   * @return true:ҋ@ false:ғ
   */
  public boolean getFlg(){
    return flg;
  }
}
