//ŏIXVҁF
package bou_n_sha.wana.data;

import java.awt.*;
import java.awt.image.*;
import java.util.*;
import javax.swing.*;

/**
 * NXBRoomAǂ𐶐AAǂ̒lB 
 *
 * @author Ryota Kushibiki
 * @see javax.swing.JComponent
 */
public class Interior extends JComponent{

	/* tB[h */
	
	//̒_W
	private	int			floorPointX[];	//XW
	private	int			floorPointY[];	//YW
	
	//grid֘A
	private	int			gridNumberX;	//gridNumberX:Obhij
	private	int			gridNumberY;	//gridNumberY:cObhij
	private	int			gridSizeX;		//PʃObh̉isNZj
	private	int			gridSizeY;		//PʃObh̍isNZj
	private	int 		gridDepth;		//slӌ`ƂẴObh̍
	private	int 		gridDelta;		//slӌ`̏Ɖ̍WI

	//Obh̒SW
	private	int			basePointX;		//PʃsNZ
	private	int			basePointY;		//PʃsNZ

	//k
	private	double		scale;

	//ǂ̒_W
	private	int			wallPointX[];	//XW
	private	int			wallPointY[];	//YW

	/**
	 * Aǂ𐶐郁\bȟĂяosB
	 * 
	 * @param	canvasSizeX	LoX̉TCY(pixel)
	 * @param	canvasSizeY	LoX̏cTCY(pixel)
	 * @param	room		RoomNX̃CX^X
	 * 
	 * @see		#floor(int,int,int,int)	floor(int,int,int,int)
	 * @see		#wall()				wall()
	 */
	public Interior(int canvasSizeX, int canvasSizeY, Room room){
		
		floor(room.getGridNumberX(),room.getGridNumberY(),canvasSizeX,canvasSizeY);
		wall();
	}
	
	/**
	 * ̐sB
	 * 
	 * @param	x			Obh()
	 * @param	y			cObh()
	 * @param	canvasSizeX	LpX̉TCY(pixel)
	 * @param	cnavasSizeY LpX̏cTCY(pixel)
	 * 
	 * @see		#Interior(int,int,Room) Interior(int,int,Room)
	 */
	public void floor(int x,int y,int canvasSizeX,int canvasSizeY){
		gridNumberX = x;
		gridNumberY = y;
		
		// `GÃ}[Wݒ
		double drawAreaMarginX = canvasSizeX * 0.1;
		double drawAreaMarginY = canvasSizeY * 0.1;
		
		// `GÃTCYݒ
		double drawAreaX = (canvasSizeX - 2 * drawAreaMarginX);
		double drawAreaY = canvasSizeY - 2 * drawAreaMarginY;

		double sheta = 0.588; //34
		
		double baseDrawSizeX = (double)( 50.0 * ( gridNumberX + 0.75 * Math.cos(sheta) * gridNumberY ));
		double scale1 =  drawAreaX / baseDrawSizeX;
		gridSizeX = (int)( 50.0 * scale1 );
		
		double baseDrawSizeY = (double)( 50.0 * gridNumberY * 0.75 * Math.sin(sheta) + 150.0 * 2.0 );
		double scale2 = drawAreaY / baseDrawSizeY;
		gridSizeY = (int)( 50.0 * scale2 );
		
		if(scale1 > scale2){
			scale = scale2;
			gridSizeX = gridSizeY;
		}else{
			scale = scale1;
			gridSizeY = gridSizeX;
		}
		
		gridDelta = (int)( 0.75 * gridSizeY * Math.cos(sheta) );
		gridDepth = (int)( 0.75 * gridSizeY * Math.sin(sheta) );
		
		//Xe[^X̎擾
		int floorSize = gridSizeX * gridNumberX;
		int floorDepth = gridDepth * gridNumberY;
		int floorDelta = gridDelta * gridNumberY;
		
		//}X̍W
		floorPointX = new int[]{ (int)drawAreaMarginX,			(int)(drawAreaMarginX+floorSize), (int)(drawAreaMarginX+floorSize+floorDelta), (int)(drawAreaMarginX+floorDelta) };
		floorPointY = new int[]{ (int)(canvasSizeY-drawAreaMarginY),	(int)(canvasSizeY-drawAreaMarginY), (int)(canvasSizeY-drawAreaMarginY-floorDepth), (int)(canvasSizeY-drawAreaMarginY-floorDepth)};
		
		//}X̒SW
		basePointX = floorPointX[3] - gridDelta;
		basePointY = floorPointY[3] + gridDepth;
		
	}
	
	/**
	 * ǂ̐sB
	 * 
	 * @see	#Interior(int,int,Room)	Interior(int,int,Room)
	 */
	public void wall(){
		
		//ǂ̍ݒ
		int wallHeight = (int)(150.0 * 2.0 * scale);
		
		//ǂ̍Wݒ
		wallPointX = new int[]{floorPointX[0], floorPointX[3], floorPointX[2], floorPointX[2], floorPointX[3],floorPointX[0]};
		wallPointY = new int[]{floorPointY[0] - wallHeight, floorPointY[3] - wallHeight, floorPointY[2]-wallHeight, floorPointY[2], floorPointY[3], floorPointY[0]};

	}
	
	/**
	 * ̒_W(X)擾B
	 * 
	 * @return	̒_XWi[z
	 */
	public int[] getFloorPointX(){
		return floorPointX;
	}
	
	/**
	 * ̒_W(Y)擾B
	 * 
	 * @return	̒_YWi[z
	 */
	public int[] getFloorPointY(){
		return floorPointY;
	}
	
	/**
	 * ǂ̒_W(X)擾B
	 * 
	 * @return ǂ̒_XWi[z
	 */
	public int[] getWallPointX(){
		return wallPointX;
	}
	
	/**
	 * ǂ̒_W(Y)擾B
	 * 
	 * @return ǂ̒_YWi[z
	 */
	public int[] getWallPointY(){
		return wallPointY;
	}
	
	/**
	 * Obh(E)̒SW(X)擾B 
	 * 
	 * @return	Obh̒SXW
	 */
	public int getBasePointX(){
		return basePointX;
	}
	
	/**
	 * Obh(E)̒SW(Y)擾B
	 * 
	 * @return	Obh̒SYW
	 */	
	public int getBasePointY(){
		return basePointY;
	}
	
	/**
	 * Obh̑擾B
	 * 
	 * @return Obh̑
	 */
	public int getGridNumberX(){
		return gridNumberX;
	}
	
	/**
	 * cObh̑擾B
	 * 
	 * @return cObh̑
	 */
	public int getGridNumberY(){
		return gridNumberY;
	}
	
	/**
	 * PʃObh̕擾B
	 * 
	 * @return	PʃObh̕(pixel)
	 */
	public int getGridSizeX(){
		return gridSizeX;
	}
	
	/**
	 * PʃObh̍擾B
	 * 
	 * @return	PʃObh̍(pixel)
	 */
	public int getGridSizeY(){
		return gridSizeY;
	}
	
	/**
	 * PʃObh𕽍slӌ`ɕό`̉s(depth)擾B<pre>
	 *      _______
	 *     /      /	
	 *    /      /@s(depth)
	 *   /______/	
	 * </pre>
	 * 
	 * @return	s(depth)
	 */
	public int getGridDepth(){
		return gridDepth;
	}
	
	/**
	 * PʃObh𕽍slӌ`ɕό`̏Ɖ̃Y擾B<pre>
	 * delta
	 *  
	 *  ---_______
	 *    /      /
	 *   /      /
	 *  /______/
	 * </pre>
	 * 
	 * @return	Ɖ̃Y(delta)
	 */
	public int getGridDelta(){
		return gridDelta;
	}
	
	/**
	 * kڂ̒l擾B
	 * 
	 * @return	kڂ̒l
	 */
	public double getScale(){
		return scale;
	}

}
