/* ŏIXVҁFY */
package bou_n_sha.wana.data;

import bou_n_sha.wana.data.character.*;
import java.awt.*;
import java.awt.image.*;
import java.util.*;
import javax.swing.*;

/**
 * ɕ\SẲ摜̊ǗsB
 * 
 * @author	Yudai Tomono
 */
public class Room extends JComponent{
	
	//private	java.util.List gameObjectList;
	//private Map	  	    gameObjectMap;
    private	ArrayList    gameObjectList;
	private HashMap	  	 gameObjectMap;
	private	int			gridNumberX;
	private	int			gridNumberY;
	
	private int			roomID;
	
	//RXgN^
	
  /**
   * Q[IuWFNgi[邽߂
   * gameObjectList𐶐BB
   * 
   * @param	x	Obh̑()
   * @param	y	cObh̑()
   * @param	id	ŗLԍ
   */
  public Room(int x, int y, int id){
    
    roomID = id;
    
    gridNumberX = x;
    gridNumberY = y;
    
    gameObjectList = new ArrayList();
    gameObjectMap = new HashMap();
    
    //gameObjectMap  = Collections.synchronizedMap(new HashMap());
    //gameObjectList = Collections.synchronizedList(new ArrayList());
  }
	
	/**
	 * ̒ɐVQ[IuWFNg̒ǉsB
	 * 
	 * @param	gameObject	GameObjectNX̃CX^X
	 * @param	gridX		`ʒuX(ObhP)
	 * @param	gridY		`ʒuY(ObhP)
	 */
	public void addObject(GameObject gameObject, int gridX, int gridY){
      synchronized(gameObjectList){
        synchronized(gameObjectMap){
          gameObject.setX(gridX);
          gameObject.setY(gridY);
          gameObjectList.add(gameObject);
          Collections.sort(gameObjectList, 
                           new Comparator() {
                             public int compare(Object o1, Object o2) {
                               GameObject first = (GameObject)o1;
                               GameObject second = (GameObject)o2;
                               return (first.getY() - second.getY());
                             }
                           }
                           );
          gameObjectMap.put(new Integer(gameObject.getObjectID()),gameObject);
        }
      }
	}
	
/** 
  * IuWFNg[폜
  * @param objID 폜IuWFNgID
  */
	public void removeObject(int objID){
      synchronized(gameObjectList){
        synchronized(gameObjectMap){
          ListIterator itr = gameObjectList.listIterator();
          int i =0;
          while( itr.hasNext() ){
            GameObject object = (GameObject)itr.next();
            if(object.getObjectID()==objID){
              gameObjectList.remove(i);
              break;
            }
            i++;
          }
          gameObjectMap.remove(new Integer(objID));
        }
      }
	}
  
	/**
	 * ړsB
	 * ܂ȀQ܂́A̒[ۂ𔻒sB
	 * ړłȂtrueAړsȂfalseԂB
	 * 
	 * @param	gameObject	GameObjectNX̃CX^X
	 * @param	x			ړsʒuX(ObhP)
	 * @param	y			ړsʒuY(ObhP)
	 * @return	ړ茋
	 */
	public boolean moveJudgment(GameCharacter gameObject, int x, int y){
		
		//ǔ
		if(x<1 || x>gridNumberX || y<1 || y>gridNumberY){
			return true;
		}
		
		//Q
		if(getObjectAt(x,y) != null){
			return true;
		}
		return false;
	}
	/**
	 * w肵WGameObject擾
	 * 
	 * @param	x			ړsʒuX(ObhP)
	 * @param	y			ړsʒuY(ObhP)
	 * @return	̍Wɑ݂GameObjectԂ
	 * 			ȂnullԂ
	 */
	public GameObject getObjectAt(int x, int y){
		if(x<1 || x>gridNumberX || y<1 || y>gridNumberY){
			return null;
		//	throw new NotInRoomException();
		}
		
		ListIterator itr = gameObjectList.listIterator();
		while( itr.hasNext() ){
			GameObject gObjTmp = (GameObject)itr.next();
			if(gObjTmp.getX() == x && gObjTmp.getY() == y ){
				return gObjTmp;
			}
		}
		return null;
	}
	
	/**
	 * gameObjectList̃\[gsB
	 * Q[IuWFNgYW(ObhP)\[g̑ΏۂɂA
	 * 摜\悤Ƀ\[gsB
	 */
	public void sortCollection(){
		
		Collections.sort(gameObjectList, 
			new Comparator() {
				public int compare(Object o1, Object o2) {
					GameObject first = (GameObject)o1;
					GameObject second = (GameObject)o2;
            		return (first.getY() - second.getY());
       			}
    		}
		); 
		
	}
	
	/**
	 * SẴQ[IuWFNg擾B
	 * 
	 * @return	Q[IuWFNgi[ArrayList
	 */
	public ArrayList getGameObjectList(){
      return gameObjectList;
	}
	
	/**
	 * Obh̑擾B
	 * 
	 * @return	Obh
	 */
	public int getGridNumberX(){
		return gridNumberX;
	}
	
	/**
	 * cObh̑擾B
	 * 
	 * @return	cObh
	 */	
	public int getGridNumberY(){
		return gridNumberY;
	}
	
	/**
	 * ̌ŗLԍ擾B
	 * 
	 * @return	ŗLԍ
	 */
	public int getRoomID(){
		return roomID;
	}
	
	/**
	 * w肳ꂽQ[IuWFNgĂяoAB
	 * ߂nB
	 * @param	objectID	Q[IuWFNǧŗLԍ
	 * @param	str			IuWFNgɗ^閽
	 */

  public void callObject( int objectID , String str){
    GameObject gameObject;
	
    if(gameObjectMap.get(new Integer(objectID)) instanceof GameObject){
      gameObject=(GameObject)gameObjectMap.get(new Integer(objectID));
      gameObject.catchCommand(str);
    }else{
      System.out.println(objectID + "̃Q[IuWFNg݂͑܂");
    }
  }

/**
	 * w肳ꂽQ[IuWFNgĂяoB
	 * 
	 * @param	objectID	Q[IuWFNǧŗLԍ
 	 * @return 	ObjectID̃Q[IuWFNg
	 */

  public  GameObject callObject(int objectID){
    GameObject 	gameObject 	= null;
	int 		id 			= objectID;
    if(gameObjectMap.get(new Integer(id)) instanceof GameObject){
      gameObject=(GameObject)gameObjectMap.get(new Integer(id));
    }else{
      System.out.println(id + "̃Q[IuWFNg݂͑܂");
    }
	  return gameObject;
  }	
}

	/**
	 * w肳ꂽObhW̓oȂƂ̗O
	 * 
	 */

class NotInRoomException extends Exception{
	NotInRoomException(){
	}
}
