package bou_n_sha.wana.view;

import bou_n_sha.wana.data.*;
import bou_n_sha.wana.data.item.*;
import java.awt.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;
import java.awt.image.*;
import java.util.*;

/**
 * CʃNX
 */
class GameDisplay extends Canvas{
  GraphicsLibrary	graphicsLibrary;
  
  GameFrame			gf;
  Room				room;			//
  Interior			interior;		//(A)
  
  //`bgp
  private	String[]	chatString;
  
  private BufferStrategy bs;

  /**
   * ʂ̉
   */
  public	int			canvasSizeX;	//CanvasSizeij
  
  /**
   * ʂ̍
   */
  public	int			canvasSizeY;	//CanvasSizeicj
  
  /**
   * RXgN^
   * @param sizeX	LoX̕(x)
   * @param	sizeY	LoX̍(y) 
   * @param gl	GraphicsLibrarỹCX^X
   */
  public GameDisplay(int sizeX, int sizeY, GraphicsLibrary gl){
    
    chatString = new String[]{ " "," "," "};
    graphicsLibrary = gl;
    
    //LoX̐ݒ
    canvasSizeX = sizeX;
    canvasSizeY = sizeY;
    
    this.setSize(sizeX,sizeY);
  }
  
  /**
   * BufferStrategy𗘗p邽߂̏s
   */
  public void initGameDisplay(){
    try{
      this.createBufferStrategy(2);
      bs = getBufferStrategy();
    }catch(IllegalStateException ex){
      ex.printStackTrace();
      System.exit(0);
    }
  }
  
  /**
   * ̓荞
   * @param	r	\镔
   */
  public void addRoom( Room r ){
    
    room = r;
    interior = new Interior(canvasSizeX,canvasSizeY,room);
    
  }

  /**
    *ʃyCg̎se
    */
  public void repaintDisplay(){
    room.sortCollection();
    repaint();
  }
  
  /**
    *`bg\
	*@param	`bg
    */
  public void showChat(String s){
    chatString[0] = chatString[1];
    chatString[1] = chatString[2];
    chatString[2] = s;
    
    //drawing();
  }

  /**
   * yCgI[o[Ch
   */
  public void repaint(){
    Graphics2D g = (Graphics2D)bs.getDrawGraphics();
    if(!bs.contentsLost()){
           g.setColor(Color.black);
      g.fillRect(0,0,canvasSizeX,canvasSizeY);
      
      g.setColor(Color.white);
      
      //̕\
      g.fillPolygon( interior.getFloorPointX() , interior.getFloorPointY() , 4 );
      
      g.setColor(new Color(220,220,220));
      
      //ǂ̕\
      g.fillPolygon( interior.getWallPointX() , interior.getWallPointY() , 6 );
      
      g.setColor(Color.black);
      
      //ǂ̋ڂ̐\
      g.drawLine(interior.getWallPointX()[1], interior.getWallPointY()[1], interior.getWallPointX()[4], interior.getWallPointY()[4]);
      g.drawLine(interior.getFloorPointX()[0], interior.getFloorPointY()[0], interior.getFloorPointX()[3], interior.getFloorPointY()[3]);
      g.drawLine(interior.getFloorPointX()[2], interior.getFloorPointY()[2], interior.getFloorPointX()[3], interior.getFloorPointY()[3]);
      
      g.setColor(Color.white);
      
      //`bg̕\
      for(int i=0;i<3;i++){
        g.drawString( chatString[i], 10, 20*(i+1) );
      }
      
      //Q[IuWFNg̕\

      ArrayList al = room.getGameObjectList();
      synchronized (al){
      //ListIterator itr = room.getGameObjectList().listIterator();
      ListIterator itr = al.listIterator();
      
      while( itr.hasNext() ){
        GameObject gObjTmp = (GameObject)itr.next();
        
        //\Ww
        Image image = graphicsLibrary.getImage(gObjTmp.getImageKey());
        int width = graphicsLibrary.getImageWidth(image);
        int height = graphicsLibrary.getImageHeight(image);
        int x = ( interior.getBasePointX() - interior.getGridDelta() * (gObjTmp.getY()-1))+( interior.getGridSizeX() * (gObjTmp.getX()-1));
        int y = ( interior.getBasePointY() + interior.getGridDepth() * (gObjTmp.getY()-1) ) - (int)(height * interior.getScale() );
        g.drawImage( image , x , y , (int)(width * interior.getScale() ) , (int)(height * interior.getScale()) , this );
      }
      }
      bs.show();
      g.dispose();
    }
  }
}

