/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.Config;
import bodybuilder.util.ExtendedPropertyUtils;
import bodybuilder.util.ObjectUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanInspector
extends Inspector {
    public void assertEquals(Object expected, Object actual, ObjectBackTrace trace) {
        Map expectedProps = ExtendedPropertyUtils.getProperties(expected);
        Map actualProps = ExtendedPropertyUtils.getProperties(actual);
        Set expectedNameSet = expectedProps.keySet();
        this.assertKeySetEquals(expectedNameSet, actualProps.keySet(), trace);
        Iterator names = expectedNameSet.iterator();
        String type = expected.getClass().getName();
        String pkg = ObjectUtils.getPackage(type, true);
        Map ignores = Config.getIgnoreProperties();
        List ignoreProps = (List)ignores.get(type);
        if (ignoreProps == null) {
            ignoreProps = (List)ignores.get(pkg);
        }
        while (names.hasNext()) {
            Object name = names.next();
            if (ignoreProps != null && ignoreProps.contains(name)) continue;
            trace.appendKey(name);
            Object expectedElement = expectedProps.get(name);
            Object actualElement = actualProps.get(name);
            BeanInspector.assertObjectEquals(expectedElement, actualElement, trace);
        }
    }
}

