/*
 * Decompiled with CFR 0.152.
 */
package bodybuilder.inspector;

import bodybuilder.exception.BodyBuilderException;
import bodybuilder.inspector.Inspector;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class InspectorMapping {
    private static Map inspectors = new HashMap();
    static /* synthetic */ Class class$bodybuilder$inspector$InspectorMapping;

    InspectorMapping() {
    }

    private static void init() {
        Map inspectorMap = Config.getInspectorMap();
        Iterator names = inspectorMap.keySet().iterator();
        HashMap<String, Inspector> cache = new HashMap<String, Inspector>();
        while (names.hasNext()) {
            String name = (String)names.next();
            String className = (String)inspectorMap.get(name);
            Inspector inspector = (Inspector)cache.get(className);
            if (inspector == null) {
                inspector = (Inspector)ObjectUtils.getObject(className);
                cache.put(className, inspector);
            }
            inspector.addTarget(name);
            inspectors.put(name, inspector);
        }
    }

    static Inspector getInspector(Object object) {
        if (object == null) {
            return null;
        }
        Inspector inspector = null;
        List classNames = ObjectUtils.getClassNames(object);
        Iterator names = classNames.iterator();
        while (names.hasNext() && inspector == null) {
            String name = (String)names.next();
            inspector = (Inspector)inspectors.get(name);
            if (inspector != null) continue;
            String pkg = ObjectUtils.getPackage(name, true);
            inspector = (Inspector)inspectors.get(pkg);
        }
        return inspector;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            InspectorMapping.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new BodyBuilderException("failed to initialize '" + (class$bodybuilder$inspector$InspectorMapping == null ? (class$bodybuilder$inspector$InspectorMapping = InspectorMapping.class$("bodybuilder.inspector.InspectorMapping")) : class$bodybuilder$inspector$InspectorMapping).getName() + "'.", e);
        }
    }
}

