package sample.testtarget.usually;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 日付ユーティリティ(static版)
 */
public class DateUtils_static {

    private DateUtils_static() {
    }

    /**
     * 日付/時刻を加算する。
     * 
     * @param field 時間フィールド
     * @param amount  フィールドに追加する日付または時刻の量
     * @return 日付文字列
     */
    public static String add(String source, int field, int amount) {
        // 日付文字列の書式をチェック。
        if (source == null || !source.matches("^[0-9]{4}-[0-9]{2}-[0-9]{2}$")) {
            return null;
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;

        // 日付文字列をパース。
        try {
            date = format.parse(source);
        } catch (ParseException e) {
            throw new RuntimeException(e);
        }

        // 日付/時刻を加算。
        return format.format(add(date, field, amount));
    }

    /**
     * 日付/時刻を加算する。
     * 
     * @param field 時間フィールド
     * @param amount  フィールドに追加する日付または時刻の量
     * @return 日付オブジェクト
     */
    private static Date add(Date date, int field, int amount) {
        // カレンダーを取得。
        Calendar cal = Calendar.getInstance();

        // 日付/時刻を加算。
        cal.setTime(date);
        cal.add(field, amount);

        // 加算した値を返す。
        return cal.getTime();
    }

}