package bodybuilder.builder.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.jdom.Element;

import com.mockrunner.mock.web.MockHttpServletRequest;

import bodybuilder.builder.Builder;
import bodybuilder.builder.argument.Argument;

/**
 * リクエストビルダー
 */
public class RequestBuilder extends Builder {

    /**
     * 属性メソッド名
     */
    private static final String METHOD_ATTR = "attr";

    /**
     * パラメータメソッド名
     */
    private static final String METHOD_PARAM = "param";

    /**
     * リクエストを取得する。
     * 
     * @param element XML要素
     * @param constructor コンストラクタ
     * @return リクエスト
     */
    public Object getMuscle(Element element, Argument constructor) {
        // モックリクエストを生成。
        MockHttpServletRequest request = new MockHttpServletRequest();

        // <param>を取得。
        List params = element.getChildren(METHOD_PARAM);
        Map paramMap = new HashMap();

        // パラメータをマップにセット。
        for (int i = 0; i < params.size(); i++) {
            Element param = (Element) params.get(i);
            String name = getRequiredName(param);
            String value = getRequiredValueAttr(param);
            List values = (List) paramMap.get(name);

            if (values == null) {
                values = new ArrayList();
                paramMap.put(name, values);
            }

            values.add(value);
        }

        // マップにセットしたパラメータをリクエストにセット。
        if (paramMap.size() > 0) {
            Iterator names = paramMap.keySet().iterator();

            while (names.hasNext()) {
                String name = (String) names.next();
                List values = (List) paramMap.get(name);
                request.setupAddParameter(name, (String[]) values
                        .toArray(new String[values.size()]));
            }
        }

        // <attr>を取得。
        List attrs = element.getChildren(METHOD_ATTR);

        // 属性をリクエストにセット。
        for (int i = 0; i < attrs.size(); i++) {
            Element child = (Element) attrs.get(i);
            String name = getRequiredName(child);
            Object value = getValue(child);
            request.setAttribute(name, value);
        }

        // リクエストを返す。
        return request;
    }

}