package bodybuilder.builder.value;

import ognl.Ognl;
import ognl.OgnlException;

import bodybuilder.exception.BodyBuilderException;

/**
 * OGNL値
 */
public class OgnlValue extends ExtendedValue {

    /**
     * プリフィックス
     */
    private static final String PREFIX = "ognl:";

    /**
     * OGNL式からオブジェクトを取得する。
     * 
     * @param value OGNL式
     * @return オブジェクト
     */
    protected Object value(String value) {
        try {
            // 式を取得。
            String expression = value.substring(PREFIX.length());
            // オブジェクトを返す。
            return Ognl.getValue(expression, (Object) null);
        } catch (OgnlException e) {
            throw new BodyBuilderException("cannot get value from OGNL '"
                    + value + "'.", e);
        }
    }

}