package bodybuilder.inspector.servlet;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletContext;
import bodybuilder.inspector.Inspector;
import bodybuilder.inspector.ObjectBackTrace;
import bodybuilder.util.ServletObjectUtils;

/**
 * サーブレットコンテキストインスペクター
 */
public class ServletContextInspector extends Inspector {

    /**
     * 二つのサーブレットコンテキストが等しいことを表明する。
     * 
     * @param expected 期待する値
     * @param actual 現実の値
     * @param trace バックトレース
     */
    public void assertEquals(Object expected, Object actual,
            ObjectBackTrace trace) {
        // サーブレットコンテキストを取得。
        ServletContext expectedContext = (ServletContext) expected;
        ServletContext actualContext = (ServletContext) actual;

        // 属性を取得。
        Map expectedAttrs = ServletObjectUtils
                .getServletContextAttributes(expectedContext);
        Map actualAttrs = ServletObjectUtils
                .getServletContextAttributes(actualContext);

        // 属性名を検査。
        Set expectedNameSet = expectedAttrs.keySet();
        assertKeySetEquals(expectedNameSet, actualAttrs.keySet(), trace);
        Iterator names = expectedNameSet.iterator();

        // 属性値を検査。
        while (names.hasNext()) {
            Object name = names.next();
            trace.appendKey(name);
            Object expectedElement = expectedAttrs.get(name);
            Object actualElement = actualAttrs.get(name);
            assertObjectEquals(expectedElement, actualElement, trace);
        }
    }

}