package bodybuilder.test.common;

import org.jdom.Element;

import bodybuilder.builder.argument.Argument;
import bodybuilder.builder.argument.ArgumentBuilder;
import bodybuilder.util.jdom.JDOMUtils;

/**
 * 実行するメソッド
 */
public class Execute {

    /**
     * メソッド名
     */
    private String method = null;

    /**
     * 引数
     */
    private Argument argument = new Argument();

    /**
     * コンストラクタ。
     * 
     * @param execute 実行要素
     */
    public Execute(Element execute) {
        // メソッド名を取得。
        method = JDOMUtils.getRequiredAttrValue(execute, "name");

        // <arg>があれば引数を生成。
        if (JDOMUtils.hasChild(execute, ArgumentBuilder.METHOD_NAME)) {
            argument = ArgumentBuilder.getArgument(execute);
        }
    }

    /**
     * メソッド名を取得する。
     * 
     * @return メソッド名
     */
    public String getMethod() {
        return method;
    }

    /**
     * 引数を取得する。
     * 
     * @return 引数
     */
    public Argument getArgument() {
        return argument;
    }

}