package bodybuilder.viewer;

import java.io.PrintWriter;
import java.io.StringWriter;
import bodybuilder.util.Config;
import bodybuilder.util.ObjectUtils;
import bodybuilder.util.Utils;
import bodybuilder.viewer.handler.OutputHandler;

/**
 * 例外ビューア
 */
public class ExceptionViewer extends Viewer {

    /**
     * 例外の内容を出力する。
     * 
     * @param object リスト
     * @param handler 出力ハンドラ
     */
    public void output(Object object, OutputHandler handler) {
        // 例外にキャスト。
        Exception e = (Exception) object;
        handler.print(ObjectUtils.getInfo(object) + " {");
        handler.indent();

        // メッセージを出力。
        if (e.getMessage() != null) {
            handler.print("[message]=>");
            dump(e.getMessage(), handler);
        }

        // スタックトレースを出力。
        if (Config.isViewPrintStackTrace()) {
            String[] trace = Utils.decorate(getStackTrace(e));
            handler.print("[stacktrace]=>");

            for (int i = 0; i < trace.length; i++) {
                handler.print(trace[i]);
            }
        }

        // 原因を出力。
        if (e.getCause() != null) {
            handler.print("[cause]=>");
            dump(e.getCause(), handler);
        }

        handler.unindent();
        handler.print("}");
    }

    /**
     * スタックトレースを取得する。
     *
     * @param e 例外
     * @return スタックトレース
     */
    private String[] getStackTrace(Exception e) {
        StringWriter writer = new StringWriter();
        PrintWriter printer = new PrintWriter(writer);
        e.printStackTrace(printer);
        String trace = writer.toString();
        return Utils.toStringArray(trace);
    }

}