using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using NicoNico.Collections;

namespace FavoriteManage
{
		public partial class AddItemDialog : Form
		{
			FavoriteTreeView _fowner;
			public AddItemDialog(FavoriteTreeView owner)
			{
				this._fowner = owner;
				InitializeComponent();
			}

			public DialogResult ShowDialog(IWin32Window owner, OrderedDictionary<long, FavoriteItem> collection)
			{
				this.constructTreeOnlyFolder(collection);
				DialogResult d = this.ShowDialog(owner);
				return d;
			}

			private void constructTreeOnlyFolder(OrderedDictionary<long, FavoriteItem> collection)
			{
				this.treeTarget.Nodes.Clear();

				List<TreeNode> nodes = new List<TreeNode>(collection.Count);
				List<long> list = new List<long>(collection.Count);
				List<int> index = new List<int>(collection.Count);

				int idx = 0;
				foreach(KeyValuePair<long, FavoriteItem> pair in collection)
				{
					if(pair.Value.IsFolder)
					{
						list.Add(pair.Key);
						nodes.Add(this.createNodeFromItem(pair.Key, pair.Value));
						index.Add(idx++);
					}
				}

				for(int i = 0; i < nodes.Count; i++)
				{
					FavoriteItem item = collection[index[i]];
					long key = item.ParentKey;
					idx = list.IndexOf(key);
					if(idx >= 0)
					{
						nodes[idx].Nodes.Add(nodes[i]);
					}
					else
					{
						this.treeTarget.Nodes.Add(nodes[i]);
					}
				}
				this.treeTarget.ExpandAll();
			}

			private TreeNode createNodeFromItem(long key, FavoriteItem item)
			{
				TreeNode tn = new TreeNode();
				tn.Text = item.Title;
				tn.Tag = (object)key;
				if(item.IsFolder)
				{
					tn.ImageIndex = FavoriteTreeView.IMAGE_INDEX_FOLDERCLOSED;
					tn.SelectedImageIndex = FavoriteTreeView.IMAGE_INDEX_FOLDERCLOSED;
					tn.Name = FavoriteTreeView.KEY_HEADER_FOLDER + key.ToString();
					if(item.Comment == String.Empty)
					{
						tn.ToolTipText = item.Title;
					}
					else
					{
						tn.ToolTipText = item.Comment;
					}
				}
				else
				{
					tn.ImageIndex = FavoriteTreeView.IMAGE_INDEX_PAGE;
					tn.SelectedImageIndex = FavoriteTreeView.IMAGE_INDEX_PAGE;
					tn.Name = FavoriteTreeView.KEY_HEADER_PAGE + key.ToString();
					if(item.Comment == String.Empty)
					{
						tn.ToolTipText = item.Title + "\n" + item.Url;
					}
					else
					{
						tn.ToolTipText = item.Comment;
					}
				}
				item.RelationNode.Expand();
				return tn;
			}


			public string TitleText
			{
				get { return this.txtTitle.Text; }
				set { this.txtTitle.Text = value; }
			}
			public string UrlText
			{
				get { return this.txtUrl.Text; }
				set { this.txtUrl.Text = value; }
			}

			public string SelectedNameArray
			{
				get
				{
					string s = "";
					TreeNode tn = this.treeTarget.SelectedNode;
					do
					{
						s = tn.Name + "\\" + s;
						tn = tn.Parent;
					}
					while(tn.Parent != null);
					return s;
				}
			}

		}
}