using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using NicoNico.Collections;
using System.IO;
using System.Xml.Serialization;
using System.Xml;
namespace FavoriteManage
{
	/// <summary>
	/// CɓǗgꂽTreeViewRg[񋟂܂
	/// </summary>
	public class FavoriteTreeView : TreeView
	{
		#region 萔
		/// <summary>
		/// y[W\ACR̃CfbNX
		/// </summary>
		public const int IMAGE_INDEX_PAGE = 0;
		/// <summary>
		/// tH_iClosedj\ACR̃CfbNX
		/// </summary>
		public const int IMAGE_INDEX_FOLDERCLOSED = 1;
		/// <summary>
		/// tH_iOpenedj\ACR̃CfbNX
		/// </summary>
		public const int IMAGE_INDEX_FOLDEROPENED = 2;
		/// <summary>
		/// TreeNodeNamevpeBŁAړID𕪂̂Ɏgp镶 '_'
		/// </summary>
		/// 
		public const char NAME_KEY_SEPARATOR = '_';
		/// <summary>
		/// TreeNodeNamevpeBŎgpړBy[W\
		/// </summary>
		public static string KEY_HEADER_PAGE { get { return "FVP_"; } }
		/// <summary>
		/// TreeNodeNamevpeBŎgpړBtH_\
		/// </summary>
		public static string KEY_HEADER_FOLDER { get { return "FVF_"; } }
		#endregion




		/// <summary>
		/// CɓRNV
		/// Keyɂ͒ǉԂTicksgp܂B
		/// </summary>
		OrderedDictionary<long, FavoriteItem> favorites;
		private ImageList imageList1;
		private ContextMenuStrip ctxMain;
		private ToolStripMenuItem tsmiMain_NewForlder;
		private ToolStripMenuItem tsmiMain_NewPage;
		private ContextMenuStrip ctxOnItem;
		private ToolStripMenuItem tsmiOnItem_Open;
		private ToolStripMenuItem tsmiOnItem_OpenNew;
		private ToolStripSeparator toolStripSeparator1;
		private ToolStripMenuItem tsmiOnItem_CreateFolder;
		private ToolStripMenuItem tsmiOnItem_Edit;
		private ToolStripMenuItem tsmiOnItem_Delete;
		private ToolStripSeparator toolStripSeparator2;
		private System.ComponentModel.IContainer components;

		internal List<TreeNode> nodes;

		private AddItemDialog dialog;

		/// <summary>
		/// ̃NX̃CX^X쐬܂B
		/// </summary>
		public FavoriteTreeView()
		{
			this.favorites = new OrderedDictionary<long, FavoriteItem>();
			this.InitializeComponent();
			this.dialog = new AddItemDialog(this);
		}

		protected override void OnMouseDown(MouseEventArgs e)
		{
			if(e.Button == MouseButtons.Middle)
			{
				TreeNode tn = this.GetNodeAt(e.Location);
				if(tn != null)
				{
					FavoriteItem fav = this.favorites[(long)tn.Tag];
					if(!fav.IsFolder)
					{
						this.OnFvNavigateRequired(fav.Url, true);
					}
				}
			}
			base.OnMouseDown(e);
		}
		protected override void OnMouseClick(MouseEventArgs e)
		{
			TreeNode tn = this.GetNodeAt(e.Location);
			if(tn != null)
			{
				FavoriteItem fav;
				if(e.Button == MouseButtons.Left)
				{
					fav = this.favorites[(long)tn.Tag];
					if(!fav.IsFolder)
					{
						this.OnFvNavigateRequired(fav.Url, false);
					}
				}
				else if(e.Button == MouseButtons.Right)
				{
				}
			}
			else
			{
				this.SelectedNode = null;
			}
			base.OnMouseClick(e);
		}


		/// <summary>
		/// w肵KeyƂCɓf[^AVTreeNodẽCX^X쐬܂B
		/// ParentKeyParentFullPathiTreeł̈ʒuɈˑ鍀ځj͍Č܂B
		/// </summary>
		/// <param name="key">RNVŊ֘AtKey</param>
		/// <param name="item">RNVŁAw肵keyɊ֘Atꂽvf</param>
		/// <returns>쐬ꂽCX^XB</returns>
		private TreeNode createNodeFromItem(long key, FavoriteItem item)
		{
			TreeNode tn = new TreeNode();
			tn.Text = item.Title;
			tn.Tag = (object)key;
			if(item.IsFolder)
			{
				tn.ImageIndex = IMAGE_INDEX_FOLDERCLOSED;
				tn.SelectedImageIndex = IMAGE_INDEX_FOLDERCLOSED;
				tn.Name = KEY_HEADER_FOLDER + key.ToString();
				if(item.Comment == String.Empty)
				{
					tn.ToolTipText = item.Title;
				}
				else
				{
					tn.ToolTipText = item.Comment;
				}
			}
			else
			{
				tn.ImageIndex = IMAGE_INDEX_PAGE;
				tn.SelectedImageIndex = IMAGE_INDEX_PAGE;
				tn.Name = KEY_HEADER_PAGE + key.ToString();
				if(item.Comment == String.Empty)
				{
					tn.ToolTipText = item.Title + "\n" + item.Url;
				}
				else
				{
					tn.ToolTipText = item.Comment;
				}
			}
			item.RelationNode = tn;
			return tn;
		}
		/// <summary>
		/// m[ḧʒuςƂɌĂяoARNVƓ܂B
		/// RNV̊evfɑ΂čsKv܂
		/// </summary>
		/// <param name="node">m[h</param>
		private void syncNodePositionChange(TreeNode node)
		{
			FavoriteItem item = favorites[(long)node.Tag];
			item.Index = node.Index;
			TreeNode par = node.Parent;
			if(par == null)
			{
				item.ParentKey = 0L;
				item.ParentFullPath = String.Empty;
			}
			else
			{
				item.ParentKey = (long)par.Tag;
				item.ParentFullPath = par.FullPath;
			}
		}
		/// <summary>
		/// 󂯎RNVc[gݗĂēǂݍ݂܂
		/// </summary>
		/// <param name="collection">gݗĂ錳ɂȂRNV</param>
		/// <returns>true</returns>
		/// <remarks>̃\bh󂯎RNVł́Ac[ŐeɂvfA
		/// ̎qɂvfɏoKv܂B</remarks>
		private bool constructTree(OrderedDictionary<long, FavoriteItem> collection)
		{
			this.Nodes.Clear();
			
			nodes = new List< TreeNode>(collection.Count);
			List<long> keys = new List<long>(collection.Count);
			int index = 0;
			foreach(KeyValuePair<long, FavoriteItem> pair in collection)
			{
				keys.Add(pair.Key);
				nodes.Add(this.createNodeFromItem(pair.Key, pair.Value));
			}

			for(int i = 0; i < nodes.Count; i++)
			{
				FavoriteItem item = collection[i];
				index = keys.IndexOf(item.ParentKey);
				if(index >= 0 && index != i)
				{
					nodes[index].Nodes.Add(nodes[i]);
				}
				else
				{
					this.Nodes.Add(nodes[i]);
				}
			}
			return true;
			/*
			TreeNode tmpNode = null;
			long tmpKey = 0L;
			foreach(KeyValuePair<long, FavoriteItem> pair in collection)
			{
				TreeNode tn = this.createNodeFromItem(pair.Key, pair.Value);
				if(pair.Value.ParentKey == 0)
				{
					this.Nodes.Add(tn);
					tmpKey = pair.Key;
					tmp = tn;
				}
				else if(tmpNode != null)
				{
					if(tmpKey == pair.Value.ParentKey)
					{
						tmpNode.Nodes.Add(tn);
					}
				}
			}
			*/
		}

		private bool recreateForSave()
		{
			OrderedDictionary<long, FavoriteItem> collection;
			try
			{
				collection = new OrderedDictionary<long, FavoriteItem>(this.favorites.Count);
				this.make(collection, this.Nodes);
			}
			catch(Exception e)
			{
				MessageBox.Show(e.Message);
				return false;
			}
			this.favorites = collection;
			return true;
		}
		private void make(OrderedDictionary<long, FavoriteItem> addTarget, TreeNodeCollection source)
		{
			long key;
			FavoriteItem item;
			foreach(TreeNode tn in source)
			{
				key = (long)tn.Tag;
				item = this.favorites[key];
				addTarget.Add(key, item);
				if(item.IsFolder)
				{
					this.make(addTarget, tn.Nodes);
				}
			}
		}

		/// <summary>
		/// VtH_m[hǉARNVɊ֘At܂B
		/// ̑Œǉm[h͎qƂł܂AURLƂ͏o܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="comment">֘AtRg</param>
		/// <param name="target">Vm[h󂯓em[hBnullnƃ[gɒǉ܂</param>
		public void FvAddFolder(string title, string comment, TreeNode target)
		{
			FavoriteItem item = new FavoriteItem(title);
			item.Comment = comment;

			if(target != null)
			{
				if(!this.favorites[(long)target.Tag].IsFolder)
				{
					target = target.Parent;
				}
				if(target == null)
				{
					item.ParentFullPath = String.Empty;
					item.Index = this.Nodes.Count;
				}
				else
				{
					item.ParentFullPath = target.FullPath;
					item.Index = target.Nodes.Count;
				}
			}
			else
			{
				item.ParentFullPath = String.Empty;
				item.Index = this.Nodes.Count;
			}

			long key = DateTime.Now.Ticks;
			TreeNode node = this.createNodeFromItem(key, item);

			this.favorites.Add(key, item);
			if(target == null)
			{
				this.Nodes.Add(node);
				item.ParentKey = 0L;
			}
			else
			{
				target.Nodes.Add(node);
				item.ParentKey = (long)target.Tag;
			}
		}
		/// <summary>
		/// VtH_m[hǉARNVɊ֘At܂Bǉe̓_CAOŕύXł܂E
		/// ̑Œǉm[h͎qƂł܂AURLƂ͏o܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="comment">֘AtRg</param>
		public void FvAddFolder(string title, string comment)
		{
			// Ƀ_CAO\
			this.FvAddFolder(title, comment, this.SelectedNode);
		}
		/// <summary>
		/// Vy[Wm[hǉARNVɊ֘At܂B
		/// ̑Œǉ͖̂[m[hŁAURLƂł܂qƂ͏o܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="url">֘AtURL</param>
		/// <param name="comment">֘AtRg</param>
		/// <param name="target">Vm[h󂯓em[hBnullnƃ[gɒǉ܂</param>
		public void FvAddItem(string title, string url, string comment, TreeNode target)
		{
			FavoriteItem item = new FavoriteItem(title, url);
			item.Comment = comment;

			if(target != null)
			{
				if(!this.favorites[(long)target.Tag].IsFolder)
				{
					target = target.Parent;
				}
				if(target == null)
				{
					item.ParentFullPath = String.Empty;
					item.Index = this.Nodes.Count;
				}
				else
				{
					item.ParentFullPath = target.FullPath;
					item.Index = target.Nodes.Count;
				}
			}
			else
			{
				item.ParentFullPath = String.Empty;
				item.Index = this.Nodes.Count;
			}

			long key = DateTime.Now.Ticks;
			TreeNode node = this.createNodeFromItem(key, item);

			this.favorites.Add(key, item);
			this.nodes.Add(node);
			if(target == null)
			{
				this.Nodes.Add(node);
				item.ParentKey = 0L;
			}
			else
			{
				target.Nodes.Add(node);
				item.ParentKey = (long)target.Tag;
			}
		}
		/// <summary>
		/// Vy[Wm[hǉARNVɊ֘At܂Bǉe̓_CAOŕύXł܂B
		/// ̑Œǉ͖̂[m[hŁAURLƂł܂qƂ͏o܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="url">֘AtURL</param>
		/// <param name="comment">֘AtRg</param>
		public void FvAddItem(string title, string url, string comment)
		{
			//Ƀ_CAO\
			this.FvAddItem(title,url,comment, this.SelectedNode);
		}
		/// <summary>
		/// w肵m[hƊ֘Atꂽvf菜܂B
		/// </summary>
		/// <param name="tn">菜m[h</param>
		/// <returns>Ήvf݂Ȃfalse</returns>
		public bool FvRemoveItem(TreeNode tn)
		{
			if(this.favorites.Remove((long)tn.Tag))
			{
				if(tn.Nodes.Count != 0)
				{
					foreach(TreeNode tnc in tn.Nodes)
					{
						this.FvRemoveItem(tnc);
					}
				}
				this.Nodes.Remove(tn);
				return true;
			}
			return false;
		}
		/// <summary>
		/// w肵m[hɑ΂ėvf̕ҏWsAeRNVɓ܂B
		/// </summary>
		/// <param name="tn">ҏWm[h</param>
		/// <param name="title">V\^Cg</param>
		/// <param name="url">V֘AtURL</param>
		/// <param name="comment">V֘AtRg</param>
		/// <returns></returns>
		public bool FvEditItem(TreeNode tn, string title, string url, string comment)
		{
			FavoriteItem item = this.favorites[(long)tn.Tag];
			item.Title = title;
			if(!item.IsFolder)
			{
				item.Url = url;
			}
			item.Comment = comment;

			tn.Text = item.Title;
			if(item.Comment != string.Empty)
			{
				tn.ToolTipText = item.Comment;
			}
			else
			{
				tn.ToolTipText = item.Title + "\n" + item.Url;
			}
			return true;
		}

		/// <summary>
		/// w肵m[hɊ֘AtꂽCɓACe擾܂
		/// </summary>
		/// <param name="tn">擾ΏۂƂȂm[h</param>
		/// <returns>֘Atꂽm[h</returns>
		public FavoriteItem FvGetItem(TreeNode tn)
		{
			FavoriteItem f = this.favorites[(long)tn.Tag];
			return f;
		}

		/// <summary>
		/// Cɓt@Cɕۑ܂
		/// t@C݂Ƃ͏㏑܂
		/// </summary>
		/// <param name="savepath">ۑt@C̃pX</param>
		/// <returns>true</returns>
		public bool FvSaveFavorite(string savepath)
		{
			//this.favorites.Sort();
			this.recreateForSave();
			if(!Path.IsPathRooted(savepath))
			{
				throw new ArgumentException("̃pX͖ł");
			}

			string xml;
			using(StringWriter writer = new StringWriter())
			{
				XmlSerializer serializer = new XmlSerializer(this.favorites.GetType());
				serializer.Serialize(writer, this.favorites);
				xml = writer.ToString();
			}
			byte[] binary = Encoding.Unicode.GetBytes(xml);
			using(System.IO.FileStream fs = new System.IO.FileStream(savepath, System.IO.FileMode.Create, System.IO.FileAccess.Write))
			{
				using(BinaryWriter writer = new BinaryWriter(fs, Encoding.Unicode))
				{
					writer.Write(binary);
				}
			}
			return true;
		}
		/// <summary>
		/// Cɓt@Cǂݍ݂܂
		/// </summary>
		/// <param name="filepath">ǂݍރt@C̃pX</param>
		/// <returns>true</returns>
		public bool FvLoadFavorite(string filepath)
		{
			string xml = string.Empty;
			byte[] binary;

			using(FileStream file = new FileStream(filepath, FileMode.Open, FileAccess.Read))
			{
				using(BinaryReader reader = new BinaryReader(file, Encoding.Unicode))
				{
					binary = reader.ReadBytes((int)file.Length);
				}
			}
			xml = Encoding.Unicode.GetString(binary);
			OrderedDictionary<long, FavoriteItem> fav = null;
			try
			{
				XmlSerializer serializer = new XmlSerializer(this.favorites.GetType());
				using(StringReader reader = new StringReader(xml))
				{
					fav = (OrderedDictionary<long, FavoriteItem>)serializer.Deserialize(reader);
				}
			}
			catch(IOException e)
			{
				MessageBox.Show("t@C̓ǂݍ݂Ɏs܂\n" + e.Message);
				return false;
			}
			catch(Exception e)
			{
				MessageBox.Show("ǂݍݒɈُm܂\n" + e.Message);
				return false;
			}
			if(fav == null) return false;
			this.constructTree(fav);
			this.favorites = fav;
			return true;
		}


		internal void FvAddFolderByKey(string title, long parentKey)
		{
			if(this.favorites.Keys.Contains(parentKey))
			{
			}
		}
		internal void FvAddItemByKey(string title, string url, long parentKey)
		{
		}


		#region Override hbOhbv

		protected override void OnDragEnter(DragEventArgs e)
		{
			base.OnDragEnter(e);
		}
		protected override void OnItemDrag(ItemDragEventArgs e)
		{
			this.SelectedNode = (TreeNode)e.Item;
			this.Focus();
			DragDropEffects dde = this.DoDragDrop(e.Item, DragDropEffects.All);
			if((dde & DragDropEffects.Move) == DragDropEffects.Move)
			{
				this.Nodes.Remove((TreeNode)e.Item);
			}
			base.OnItemDrag(e);
		}
		protected override void OnDragOver(DragEventArgs e)
		{
			if(e.Data.GetDataPresent(typeof(TreeNode)))
			{
				if((e.KeyState & 8) == 8 && ((e.AllowedEffect & DragDropEffects.Copy) == DragDropEffects.Copy))
				{
					e.Effect = DragDropEffects.Copy;
				}
				else if((e.AllowedEffect & DragDropEffects.Move) == DragDropEffects.Move)
				{
					e.Effect = DragDropEffects.Move;
				}
				else
				{
					e.Effect = DragDropEffects.None;
				}
			}
			else
			{
				e.Effect = DragDropEffects.None;
			}
			if(e.Effect != DragDropEffects.None)
			{
				TreeNode target = this.GetNodeAt(this.PointToClient(new Point(e.X, e.Y)));
				TreeNode source = (TreeNode)e.Data.GetData(typeof(TreeNode));
				if(target != null && target != source && !isChildNode(source, target))
				{
					if(target.IsSelected == false) this.SelectedNode = target;
				}
				else { e.Effect = DragDropEffects.None; }
			}
			base.OnDragOver(e);
		}
		protected override void OnDragDrop(DragEventArgs e)
		{
			if(e.Data.GetDataPresent(typeof(TreeNode)))
			{
				TreeNode source = (TreeNode)e.Data.GetData(typeof(TreeNode));
				TreeNode target = this.GetNodeAt(this.PointToClient(new Point(e.X, e.Y)));
				if(target != null && target != source && !isChildNode(source, target))
				{
					TreeNodeCollection scollection;
					TreeNodeCollection tcollection;
					if(source.Parent != null) { scollection = source.Parent.Nodes; }
					else { scollection = this.Nodes; }

					TreeNode clone = (TreeNode)source.Clone();
					if(target.ImageIndex != IMAGE_INDEX_PAGE) // ^[QbgtH_ł邱Ƃ`FbN
					{
						scollection.Remove(source);
						target.Nodes.Add(clone);
						foreach(TreeNode tn in target.Nodes)
						{
							this.syncNodePositionChange(tn);
						}
						if(scollection != target.Nodes)
						{
							foreach(TreeNode tn in scollection)
							{
								this.syncNodePositionChange(tn);
							}
						}
					}
					else
					{
						if(target.Parent != null)
						{
							tcollection = target.Parent.Nodes;
						}
						else
						{
							tcollection = this.Nodes;
						}
						int index = tcollection.IndexOf(target);
						scollection.Remove(source);
						tcollection.Insert(index, clone);
						foreach(TreeNode tn in tcollection)
						{
							this.syncNodePositionChange(tn);
						}
						if(scollection != tcollection)
						{
							foreach(TreeNode tn in scollection)
							{
								this.syncNodePositionChange(tn);
							}
						}
					}
					target.Expand();
					this.SelectedNode = clone;
				}
				else { e.Effect = DragDropEffects.None; }
			}
			else { e.Effect = DragDropEffects.None; }
			base.OnDragDrop(e);
		}

		#endregion



		#region Event
		/// <summary>
		/// ̃Rg[y[ẄړvꂽƂɔ܂B
		/// </summary>
		public event EventHandler<UrlEventArgs> FvNavigateRequired;

		protected void OnFvNavigateRequired(string url, bool newWindow)
		{
			if(FvNavigateRequired != null)
			{
				FvNavigateRequired(this, new UrlEventArgs(url, newWindow));
			}
		}

		#endregion


		/// <summary>
		/// childAparent̎qm[hł邩𔻒B
		/// </summary>
		/// <param name="parent">cm[h</param>
		/// <param name="child">qm[h</param>
		/// <returns>qłtrue</returns>
		private static bool isChildNode(TreeNode parent, TreeNode child)
		{
			if(child.Parent == parent)
			{
				return true;
			}
			else if(child.Parent != null)
			{
				return isChildNode(parent, child.Parent);
			}
			else { return false; }
		}

		/// <summary>
		/// fUCi[̃A
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FavoriteTreeView));
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.ctxMain = new System.Windows.Forms.ContextMenuStrip(this.components);
			this.tsmiMain_NewForlder = new System.Windows.Forms.ToolStripMenuItem();
			this.tsmiMain_NewPage = new System.Windows.Forms.ToolStripMenuItem();
			this.ctxOnItem = new System.Windows.Forms.ContextMenuStrip(this.components);
			this.tsmiOnItem_Open = new System.Windows.Forms.ToolStripMenuItem();
			this.tsmiOnItem_OpenNew = new System.Windows.Forms.ToolStripMenuItem();
			this.tsmiOnItem_CreateFolder = new System.Windows.Forms.ToolStripMenuItem();
			this.tsmiOnItem_Edit = new System.Windows.Forms.ToolStripMenuItem();
			this.tsmiOnItem_Delete = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
			this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
			this.ctxMain.SuspendLayout();
			this.ctxOnItem.SuspendLayout();
			this.SuspendLayout();
			// 
			// imageList1
			// 
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Magenta;
			this.imageList1.Images.SetKeyName(0, "document.bmp");
			this.imageList1.Images.SetKeyName(1, "XPfolder_closed.bmp");
			this.imageList1.Images.SetKeyName(2, "XPfolder_Open.bmp");
			// 
			// ctxMain
			// 
			this.ctxMain.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.tsmiMain_NewForlder,
            this.tsmiMain_NewPage});
			this.ctxMain.Name = "ctxMain";
			this.ctxMain.Size = new System.Drawing.Size(184, 48);
			// 
			// tsmiMain_NewForlder
			// 
			this.tsmiMain_NewForlder.Name = "tsmiMain_NewForlder";
			this.tsmiMain_NewForlder.Size = new System.Drawing.Size(183, 22);
			this.tsmiMain_NewForlder.Text = "VtH_";
			// 
			// tsmiMain_NewPage
			// 
			this.tsmiMain_NewPage.Name = "tsmiMain_NewPage";
			this.tsmiMain_NewPage.Size = new System.Drawing.Size(183, 22);
			this.tsmiMain_NewPage.Text = "Vy[Wo^";
			// 
			// ctxOnItem
			// 
			this.ctxOnItem.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.tsmiOnItem_Open,
            this.tsmiOnItem_OpenNew,
            this.toolStripSeparator1,
            this.tsmiOnItem_CreateFolder,
            this.toolStripSeparator2,
            this.tsmiOnItem_Edit,
            this.tsmiOnItem_Delete});
			this.ctxOnItem.Name = "ctxOnItem";
			this.ctxOnItem.Size = new System.Drawing.Size(147, 120);
			// 
			// tsmiOnItem_Open
			// 
			this.tsmiOnItem_Open.Name = "tsmiOnItem_Open";
			this.tsmiOnItem_Open.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_Open.Text = "J";
			// 
			// tsmiOnItem_OpenNew
			// 
			this.tsmiOnItem_OpenNew.Name = "tsmiOnItem_OpenNew";
			this.tsmiOnItem_OpenNew.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_OpenNew.Text = "V^uŊJ";
			// 
			// tsmiOnItem_CreateFolder
			// 
			this.tsmiOnItem_CreateFolder.Name = "tsmiOnItem_CreateFolder";
			this.tsmiOnItem_CreateFolder.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_CreateFolder.Text = "tH_쐻";
			// 
			// tsmiOnItem_Edit
			// 
			this.tsmiOnItem_Edit.Name = "tsmiOnItem_Edit";
			this.tsmiOnItem_Edit.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_Edit.Text = "ҏW";
			// 
			// tsmiOnItem_Delete
			// 
			this.tsmiOnItem_Delete.Name = "tsmiOnItem_Delete";
			this.tsmiOnItem_Delete.Size = new System.Drawing.Size(146, 22);
			this.tsmiOnItem_Delete.Text = "폜";
			// 
			// toolStripSeparator1
			// 
			this.toolStripSeparator1.Name = "toolStripSeparator1";
			this.toolStripSeparator1.Size = new System.Drawing.Size(143, 6);
			// 
			// toolStripSeparator2
			// 
			this.toolStripSeparator2.Name = "toolStripSeparator2";
			this.toolStripSeparator2.Size = new System.Drawing.Size(143, 6);
			// 
			// FavoriteTreeView
			// 
			this.AllowDrop = true;
			this.HideSelection = false;
			this.ImageIndex = 0;
			this.ImageList = this.imageList1;
			this.LineColor = System.Drawing.Color.Black;
			this.SelectedImageIndex = 0;
			this.ctxMain.ResumeLayout(false);
			this.ctxOnItem.ResumeLayout(false);
			this.ResumeLayout(false);

		}



		public void ShowEditDialog()
		{
			this.dialog.ShowDialog(this, this.favorites);
		}

	}

	/// <summary>
	/// CxgURL󂯓nɗpEventArgs`܂
	/// </summary>
	public class UrlEventArgs : EventArgs
	{
		string _url;
		bool _newwin;
		/// <summary>
		/// vꂽړURL擾܂
		/// </summary>
		public string Url
		{
			get { return this._url; }
		}
		/// <summary>
		/// VEBhEŊJƂvĂ邩ǂ擾܂
		/// </summary>
		public bool NewWindow
		{
			get { return this._newwin; }
		}

		/// <summary>
		/// VCX^X쐬܂
		/// </summary>
		/// <param name="url">ړURL</param>
		/// <param name="newwindow">VEBhEŊJǂ</param>
		public UrlEventArgs(string url, bool newwindow)
		{
			this._url = url;
			this._newwin = newwindow;
		}

		//public enum ActionFrags

	}
}
