using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace FavoriteManage
{
	public partial class Form1 : Form
	{
		string infobase = "Index : \t{0}\r\nParentKey : {1}\r\nFullPath : {2}\r\n";
		string savepath = Application.StartupPath + "\\boonfav.xml";

		public Form1()
		{
			InitializeComponent();
			this.textBoxExpl.Text = "LoadăTvJĂ";
			this.button6.Focus();
		}
		//Add
		private void button3_Click(object sender, EventArgs e)
		{
			if(textBox1.Text == "") return;
			string target = String.Empty;
			if(this.favoriteTreeView1.SelectedNode != null)
			{
				target = this.favoriteTreeView1.SelectedNode.FullPath;
			}
			if(checkBox1.Checked)
			{
				this.favoriteTreeView1.FvAddFolder(this.textBox1.Text, this.textBox3.Text, this.favoriteTreeView1.SelectedNode);
			}
			else
			{
				if(textBox2.Text == String.Empty) return;
				this.favoriteTreeView1.FvAddItem(this.textBox1.Text, this.textBox2.Text, this.textBox3.Text, this.favoriteTreeView1.SelectedNode);
			}
		}
		// Get
		private void button1_Click(object sender, EventArgs e)
		{
			if(this.favoriteTreeView1.SelectedNode == null) return;
			FavoriteItem f = this.favoriteTreeView1.FvGetItem(this.favoriteTreeView1.SelectedNode);
			this.textBox1.Text = f.Title;
			this.textBox2.Text = f.Url;
			this.textBox3.Text = f.Comment;
			this.checkBox1.Checked = f.IsFolder;
			this.textBoxExpl.Text = String.Format(this.infobase, f.Index, f.ParentKey, f.ParentFullPath);
		}

		// Remove
		private void button2_Click(object sender, EventArgs e)
		{
			if(this.favoriteTreeView1.SelectedNode == null) return;
			this.favoriteTreeView1.FvRemoveItem(this.favoriteTreeView1.SelectedNode);
		}

		// Edit
		private void button4_Click(object sender, EventArgs e)
		{
			if(this.favoriteTreeView1.SelectedNode == null) return;
			if(this.textBox1.Text == String.Empty) return;
			this.favoriteTreeView1.FvEditItem(this.favoriteTreeView1.SelectedNode,
				this.textBox1.Text, textBox2.Text, textBox3.Text);
		}

		// Save
		private void button5_Click(object sender, EventArgs e)
		{
			SaveFileDialog sfd = new SaveFileDialog();
			sfd.FileName = savepath;
			sfd.Filter = "Favorite File (.xml)|*.xml";
			if(sfd.ShowDialog() == DialogResult.OK)
			{
				this.favoriteTreeView1.FvSaveFavorite(sfd.FileName);
			}
		}

		// Load
		private void button6_Click(object sender, EventArgs e)
		{
			OpenFileDialog ofd = new OpenFileDialog();
			ofd.FileName = savepath;
			ofd.Filter = "Favorite File (.xml)|*.xml";
			if(ofd.ShowDialog() == DialogResult.OK)
			{
				this.favoriteTreeView1.FvLoadFavorite(ofd.FileName);
			}
		}

		private void favoriteTreeView1_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			TreeNode tn = this.favoriteTreeView1.GetNodeAt(e.Location);
			if(tn != null)
			{
				FavoriteItem f = this.favoriteTreeView1.FvGetItem(tn);
				this.textBox1.Text = f.Title;
				this.textBox2.Text = f.Url;
				this.textBox3.Text = f.Comment;
				this.checkBox1.Checked = f.IsFolder;
				this.textBoxExpl.Text = String.Format(this.infobase, f.Index, f.ParentKey, f.ParentFullPath);
			}
			else
			{
				this.favoriteTreeView1.SelectedNode = null;
				this.textBox1.Text = "";
				this.textBox2.Text = "";
				this.textBox3.Text = "";
				this.checkBox1.Checked = false;
				this.textBoxExpl.Text = "";
			}
		}

		private void checkBox1_CheckedChanged(object sender, EventArgs e)
		{
			if(this.checkBox1.Checked)
			{
				this.textBox2.Enabled = false;
			}
			else
			{
				this.textBox2.Enabled = true;
			}
		}
		private void Form1_Click(object sender, EventArgs e)
		{
			this.favoriteTreeView1.ShowEditDialog();
		}

		private void favoriteTreeView1_FvNavigateRequired(object sender, UrlEventArgs e)
		{
			this.textBox4.Text = "Open" + (e.NewWindow ? " NEW " : " ") + "Window / " + e.Url;
		}

		
	}
}