#!/usr/local/bin/ruby

#==============================================================================#
# bin/brbcmp.rb
# $Id: brbcmp.rb,v 1.3 2003/02/03 05:57:46 yuya Exp $
#==============================================================================#

require 'bruby'
require 'getoptlong'

#==============================================================================#
# BRbCmpCommand Module
module BRbCmpCommand

  def self.main
    options = parse_argv

    if options[:help] || ARGV.size < 1
      print_usage
    end

    inputfile  = ARGV[0]
    outputfile = options[:output] || inputfile.sub(/(\.rb$|$)/, '.brb')

    BRb.debug = options[:debug]

    binary = BRb.dumpfile(inputfile)
    File.open(outputfile, 'wb') { |file| file.write(binary) }
  end

  def self.parse_argv
    parser = GetoptLong.new
    parser.set_options(
      ['--output', '-o', GetoptLong::REQUIRED_ARGUMENT],
      ['--debug',  '-g', GetoptLong::NO_ARGUMENT],
      ['--help',   '-h', GetoptLong::NO_ARGUMENT]
    )

    options = {}
    parser.each_option { |name, argument|
      options[name.sub(/^--/, '').intern] = argument
    }

    options[:debug] = !!options[:debug]
    options[:help]  = !!options[:help]

    return options
  rescue GetoptLong::InvalidOption
    exit(1)
  end

  def self.print_usage
    STDERR.puts "bRuby #{BRb::VERSION}"
    STDERR.puts "Usage: brbcmp.rb [options] file"
    STDERR.puts "Options:"
    STDERR.puts "  -o  --output   specifies output file name."
    STDERR.puts "  -g  --debug    enable debug mode."
    STDERR.puts "  -h  --help     display this information."
    exit(1)
  end

end # BRbCmpCommand

#==============================================================================#

BRbCmpCommand.main

#==============================================================================#
#==============================================================================#
