// $Id: BRbReadNode.h,v 1.13 2003/02/03 05:46:42 yuya Exp $

#ifdef BRB_READER
#ifndef _BRbReadNode_h_
#define _BRbReadNode_h_

////////////////////////////////////////////////////////////////////////////////

#include "BRbBase.h"
#include "BRbNode.h"
#include "BRbInputBuffer.h"
#include "BRbStringTable.h"
#include "BRbDebug.h"

////////////////////////////////////////////////////////////////////////////////

class BRbReadNode : public BRbNode
{

public:
	BRbReadNode(BRbInputBuffer& buffer, BRbDebug& debug);
	virtual ~BRbReadNode();

public:
	virtual NODE* read();

protected:
	virtual BRbHeader read_header();
	virtual NODE* read_node();
	virtual NODE* read_node_opt();
	virtual NODE* read_node_opts(byte opt, int n);
	virtual byte read_byte();
	virtual word read_word();
	virtual dword read_dword();
	virtual const char* read_cstr();
	virtual const char* read_cstr(word* len);
	virtual VALUE read_string();
	virtual ID read_id();
	virtual VALUE read_literal();
	virtual VALUE read_object();

protected:
	BRbInputBuffer& m_buffer;
	BRbStringTable m_strtbl;
	BRbDebug& m_debug;

};

////////////////////////////////////////////////////////////////////////////////

#endif
#endif

////////////////////////////////////////////////////////////////////////////////
