/*****************************************************************************/
/* The development of this program is partly supported by IPA                */
/* (Information-Technology Promotion Agency, Japan).                         */
/*****************************************************************************/

/*****************************************************************************/
/*  bt.h - branch tracer for linux common header                             */
/*  Copyright: Copyright (c) Hitachi, Ltd. 2005-2006                         */
/*             Authors: Yumiko Sugita (sugita@sdl.hitachi.co.jp),            */
/*                      Satoshi Fujiwara (sa-fuji@sdl.hitachi.co.jp)         */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#ifndef __BT_H__
#define __BT_H__

#ifndef __KERNEL__
# include <sys/types.h>
#endif

#define BT_FLAG_OVERFLOW	(1 << 29)
#define BT_FLAG_DEBUG		(1 << 30)
#define BT_FLAG_PID		(1 << 31)
#define	is_pid_record(r)	((r)->flags & BT_FLAG_PID)
#define	is_overflow_record(r)	((r)->flags & BT_FLAG_OVERFLOW)

struct bt_record {
	unsigned long	from;
	unsigned long	to;
	unsigned long	flags;
};

struct pid_record {
	unsigned long	pid;
	unsigned long	tv_sec;
	unsigned long	tv_usec;
};

#ifdef __KERNEL__
#include <asm/types.h>

/* MSRs */
#define MSR_IA32_DS_AREA	0x600
#define MSR_DEBUGCTLA		0x1d9
#define MSR_DEBUGCTLA_LBR	(1)
#define MSR_DEBUGCTLA_BTF	(1 << 1)
#define MSR_DEBUGCTLA_TR	(1 << 2)
#define MSR_DEBUGCTLA_BTS	(1 << 3)
#define MSR_DEBUGCTLA_BTINT	(1 << 4)

#define	BTS_BUF_MIN_SIZE	(sizeof(struct bt_record) * 0x10000)
//#define	THRESHOLD_RECS		256
#define	THRESHOLD_RECS		1024

#define is_app_mode		pid_cnt

#define MOD_NAME		"bt_mod"

struct ds_manage {
	unsigned long	bts_base;
	unsigned long	bts_index;
	unsigned long	bts_max;
	unsigned long	bts_threshold;
	unsigned long	pebs_base;
	unsigned long	pebs_index;
	unsigned long	pebs_max;
	unsigned long	pebs_threshold;
	unsigned long	pebs_cnt_reset;
	char		reserved[24];
};

struct pid_manage {
	pid_t	pid;
	int	is_wrote;
};

void bt_enable(void);
void bt_disable(void);

/* for serial console prints */
int serial_init(int);
asmlinkage int serial_prints(const char *, ...);

#else

#define	ALL_PID			-1

struct addr_range {
	unsigned long		begin;
	unsigned long		end;
	struct addr_range	*next;
};

struct pid_range {
	pid_t			pid;
	struct addr_range	*range;
	struct pid_range	*next;
};

int alloc_pid_range(pid_t);
void free_ranges(void);
char* range2ulongs(char*, unsigned long*, unsigned long*);
int add_range(pid_t, unsigned long, unsigned long);
int del_range(pid_t, unsigned long, unsigned long);
void dump_ranges(void);
struct pid_range *get_all_ranges(void);
struct addr_range *get_pid_addr_range(pid_t);
int is_addr_match(struct bt_record*, struct addr_range*);

#define MAX_LINE_LEN	256
#define MAX_NAME_LEN	128
typedef int (*t_func_r2n)(unsigned long, unsigned long, char*, char*, int);
int open_mmapfile(char*, int*, void**, size_t*);
void close_mmapfile(int, void*, size_t);
int parse_modules(t_func_r2n, char*);
int parse_maps(t_func_r2n, char*, char*);

#endif /* __KERNEL__ */

#endif /*__BT_H__*/
