/* Copyright 1992 NEC Corporation, Tokyo, Japan.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice
 * appear in supporting documentation, and that the name of NEC
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior
 * permission.  NEC Corporation makes no representations about the
 * suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN 
 * NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF 
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR 
 * OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR 
 * PERFORMANCE OF THIS SOFTWARE. 
 */

#if !defined(lint) && !defined(__CODECENTER__)
static char alphamap_id[] = "@(#) 102.1 $Id: alphamap.h,v 1.1.1.1 2002/10/19 08:27:48 aida_s Exp $";
#endif /* lint */

extern int JapaneseMode();
extern DoFuncSequence(),UseOtherKeymap();

static struct funccfunc alpha_funcs[] = {
  {CANNA_FN_SelfInsert		,AlphaSelfInsert	},
  {CANNA_FN_JapaneseMode	,JapaneseMode		},
  {CANNA_FN_Nop			,AlphaNop		},
  {CANNA_FN_FuncSequence	,DoFuncSequence		},
  {CANNA_FN_UseOtherKeymap	,UseOtherKeymap		},
  {CANNA_FN_FunctionalInsert	,AlphaSelfInsert	},
  {DEFAULTBEHAVIOR		,AlphaSelfInsert	},

#ifdef WIN
  {CANNA_FN_DefineDicMode	,dicTouroku		},
  {CANNA_FN_DeleteDicMode	,dicSakujo		},

  {CANNA_FN_HenkanRegion	,HenkanRegion		},
  {CANNA_FN_PhonoEdit		,PhonoEdit		},
  {CANNA_FN_DicEdit		,DicEdit		},
  {CANNA_FN_Configure		,Configure		},
#endif
  {0				,0			},
};

BYTE alpha_kmap[256] =
{               
/* C-@ */       CANNA_FN_SelfInsert,
/* C-a */       CANNA_FN_SelfInsert,
/* C-b */       CANNA_FN_SelfInsert,
/* C-c */       CANNA_FN_SelfInsert,
/* C-d */       CANNA_FN_SelfInsert,
/* C-e */       CANNA_FN_SelfInsert,
/* C-f */       CANNA_FN_SelfInsert,
/* C-g */       CANNA_FN_SelfInsert,
/* C-h */       CANNA_FN_SelfInsert,
/* C-i */       CANNA_FN_SelfInsert,
/* C-j */       CANNA_FN_SelfInsert,
/* C-k */       CANNA_FN_SelfInsert,
/* C-l */       CANNA_FN_SelfInsert,
/* C-m */       CANNA_FN_SelfInsert,
/* C-n */       CANNA_FN_SelfInsert,
/* C-o */       CANNA_FN_JapaneseMode,
/* C-p */       CANNA_FN_SelfInsert,
/* C-q */       CANNA_FN_SelfInsert,
/* C-r */       CANNA_FN_SelfInsert,
/* C-s */       CANNA_FN_SelfInsert,
/* C-t */       CANNA_FN_SelfInsert,
/* C-u */       CANNA_FN_SelfInsert,
/* C-v */       CANNA_FN_SelfInsert,
/* C-w */       CANNA_FN_SelfInsert,
/* C-x */       CANNA_FN_SelfInsert,
/* C-y */       CANNA_FN_SelfInsert,
/* C-z */       CANNA_FN_SelfInsert,
/* C-[ */       CANNA_FN_SelfInsert,
/* C-\ */       CANNA_FN_SelfInsert,
/* C-] */       CANNA_FN_SelfInsert,
/* C-^ */       CANNA_FN_SelfInsert,
/* C-_ */       CANNA_FN_SelfInsert,
/* space */     CANNA_FN_SelfInsert,
/* ! */         CANNA_FN_SelfInsert,
/* " */         CANNA_FN_SelfInsert,
/* # */         CANNA_FN_SelfInsert,
/* $ */         CANNA_FN_SelfInsert,
/* % */         CANNA_FN_SelfInsert,
/* & */         CANNA_FN_SelfInsert,
/* ' */         CANNA_FN_SelfInsert,
/* ( */         CANNA_FN_SelfInsert,
/* ) */         CANNA_FN_SelfInsert,
/* * */         CANNA_FN_SelfInsert,
/* + */         CANNA_FN_SelfInsert,
/* , */         CANNA_FN_SelfInsert,
/* - */         CANNA_FN_SelfInsert,
/* . */         CANNA_FN_SelfInsert,
/* / */         CANNA_FN_SelfInsert,
/* 0 */         CANNA_FN_SelfInsert,
/* 1 */         CANNA_FN_SelfInsert,
/* 2 */         CANNA_FN_SelfInsert,
/* 3 */         CANNA_FN_SelfInsert,
/* 4 */         CANNA_FN_SelfInsert,
/* 5 */         CANNA_FN_SelfInsert,
/* 6 */         CANNA_FN_SelfInsert,
/* 7 */         CANNA_FN_SelfInsert,
/* 8 */         CANNA_FN_SelfInsert,
/* 9 */         CANNA_FN_SelfInsert,
/*   : */       CANNA_FN_SelfInsert,
/* ; */         CANNA_FN_SelfInsert,
/* < */         CANNA_FN_SelfInsert,
/* = */         CANNA_FN_SelfInsert,
/* > */         CANNA_FN_SelfInsert,
/* ? */         CANNA_FN_SelfInsert,
/* @ */         CANNA_FN_SelfInsert,
/* A */         CANNA_FN_SelfInsert,
/* B */         CANNA_FN_SelfInsert,
/* C */         CANNA_FN_SelfInsert,
/* D */         CANNA_FN_SelfInsert,
/* E */         CANNA_FN_SelfInsert,
/* F */         CANNA_FN_SelfInsert,
/* G */         CANNA_FN_SelfInsert,
/* H */         CANNA_FN_SelfInsert,
/* I */         CANNA_FN_SelfInsert,
/* J */         CANNA_FN_SelfInsert,
/* K */         CANNA_FN_SelfInsert,
/* L */         CANNA_FN_SelfInsert,
/* M */         CANNA_FN_SelfInsert,
/* N */         CANNA_FN_SelfInsert,
/* O */         CANNA_FN_SelfInsert,
/* P */         CANNA_FN_SelfInsert,
/* Q */         CANNA_FN_SelfInsert,
/* R */         CANNA_FN_SelfInsert,
/* S */         CANNA_FN_SelfInsert,
/* T */         CANNA_FN_SelfInsert,
/* U */         CANNA_FN_SelfInsert,
/* V */         CANNA_FN_SelfInsert,
/* W */         CANNA_FN_SelfInsert,
/* X */         CANNA_FN_SelfInsert,
/* Y */         CANNA_FN_SelfInsert,
/* Z */         CANNA_FN_SelfInsert,
/* [ */         CANNA_FN_SelfInsert,
/* \ */         CANNA_FN_SelfInsert,
/* ] */         CANNA_FN_SelfInsert,
/* ^ */         CANNA_FN_SelfInsert,
/* _ */         CANNA_FN_SelfInsert,
/* ` */         CANNA_FN_SelfInsert,
/* a */         CANNA_FN_SelfInsert,
/* b */         CANNA_FN_SelfInsert,
/* c */         CANNA_FN_SelfInsert,
/* d */         CANNA_FN_SelfInsert,
/* e */         CANNA_FN_SelfInsert,
/* f */         CANNA_FN_SelfInsert,
/* g */         CANNA_FN_SelfInsert,
/* h */         CANNA_FN_SelfInsert,
/* i */         CANNA_FN_SelfInsert,
/* j */         CANNA_FN_SelfInsert,
/* k */         CANNA_FN_SelfInsert,
/* l */         CANNA_FN_SelfInsert,
/* m */         CANNA_FN_SelfInsert,
/* n */         CANNA_FN_SelfInsert,
/* o */         CANNA_FN_SelfInsert,
/* p */         CANNA_FN_SelfInsert,
/* q */         CANNA_FN_SelfInsert,
/* r */         CANNA_FN_SelfInsert,
/* s */         CANNA_FN_SelfInsert,
/* t */         CANNA_FN_SelfInsert,
/* u */         CANNA_FN_SelfInsert,
/* v */         CANNA_FN_SelfInsert,
/* w */         CANNA_FN_SelfInsert,
/* x */         CANNA_FN_SelfInsert,
/* y */         CANNA_FN_SelfInsert,
/* z */         CANNA_FN_SelfInsert,
/* { */         CANNA_FN_SelfInsert,
/* | */         CANNA_FN_SelfInsert,
/* } */         CANNA_FN_SelfInsert,
/* ~ */         CANNA_FN_SelfInsert,
/* DEL */       CANNA_FN_SelfInsert,
/* Nfer */      CANNA_FN_SelfInsert,
/* Xfer */      CANNA_FN_JapaneseMode,
/* Up */        CANNA_FN_SelfInsert,
/* Left */      CANNA_FN_SelfInsert,
/* Right */     CANNA_FN_SelfInsert,
/* Down */      CANNA_FN_SelfInsert,
/* Insert */    CANNA_FN_SelfInsert,
/* Rollup */    CANNA_FN_SelfInsert,
/* Rolldown */  CANNA_FN_SelfInsert,
/* Home */      CANNA_FN_SelfInsert,
/* Help */      CANNA_FN_SelfInsert,
/* KeyPad */    CANNA_FN_SelfInsert,
/* 8c */        CANNA_FN_SelfInsert,
/* 8d */        CANNA_FN_SelfInsert,
/* 8e */        CANNA_FN_SelfInsert,
/* 8f */        CANNA_FN_SelfInsert,
/* S-nfer */    CANNA_FN_SelfInsert,
/* S-xfer */    CANNA_FN_JapaneseMode,
/* S-up */      CANNA_FN_SelfInsert,
/* S-left */    CANNA_FN_SelfInsert,
/* S-right */   CANNA_FN_SelfInsert,
/* S-down */    CANNA_FN_SelfInsert,
/* C-nfer */    CANNA_FN_SelfInsert,
/* C-xfer */    CANNA_FN_JapaneseMode,
/* C-up */      CANNA_FN_SelfInsert,
/* C-left */    CANNA_FN_SelfInsert,
/* C-right */   CANNA_FN_SelfInsert,
/* C-down */    CANNA_FN_SelfInsert,
/* 9c */        CANNA_FN_SelfInsert,
/* 9d */        CANNA_FN_SelfInsert,
/* 9e */        CANNA_FN_SelfInsert,
/* 9f */        CANNA_FN_SelfInsert,
/* KANASPACE */ CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/*  */        CANNA_FN_SelfInsert,
/* F1 */        CANNA_FN_SelfInsert,
/* F2 */        CANNA_FN_SelfInsert,
/* F3 */        CANNA_FN_SelfInsert,
/* F4 */        CANNA_FN_SelfInsert,
/* F5 */        CANNA_FN_SelfInsert,
/* F6 */        CANNA_FN_SelfInsert,
/* F7 */        CANNA_FN_SelfInsert,
/* F8 */        CANNA_FN_SelfInsert,
/* F9 */        CANNA_FN_SelfInsert,
/* F10 */       CANNA_FN_SelfInsert,
/* ea */        CANNA_FN_SelfInsert,
/* eb */        CANNA_FN_SelfInsert,
/* ec */        CANNA_FN_SelfInsert,
/* ed */        CANNA_FN_SelfInsert,
/* ee */        CANNA_FN_SelfInsert,
/* ef */        CANNA_FN_SelfInsert,
/* PF1 */       CANNA_FN_SelfInsert,
/* PF2 */       CANNA_FN_SelfInsert,
/* PF3 */       CANNA_FN_SelfInsert,
/* PF4 */       CANNA_FN_SelfInsert,
/* PF5 */       CANNA_FN_SelfInsert,
/* PF6 */       CANNA_FN_SelfInsert,
/* PF7 */       CANNA_FN_SelfInsert,
/* PF8 */       CANNA_FN_SelfInsert,
/* PF9 */       CANNA_FN_SelfInsert,
/* PF10 */      CANNA_FN_SelfInsert,
/* fa */        CANNA_FN_SelfInsert,
/* fb */        CANNA_FN_SelfInsert,
/* fc */        CANNA_FN_SelfInsert,
/* fd */        CANNA_FN_SelfInsert,
/* fe */        CANNA_FN_SelfInsert,
/* ff */        CANNA_FN_SelfInsert,
};


KanjiModeRec alpha_mode = {
  searchfunc,
  alpha_kmap,
  CANNA_KANJIMODE_TABLE_SHARED | CANNA_KANJIMODE_EMPTY_MODE,
  alpha_funcs,
};
