/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.application;

import java.lang.reflect.Constructor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;

public abstract class SingletonApplication
extends Application {
    private static Class<? extends Application> appClass;
    private static AtomicInteger count;
    private static CountDownLatch latch;
    private static volatile Stage primaryStage;
    private static volatile boolean isStopped;

    public static void launch(Class<? extends Application> appClass, String ... args) {
        SingletonApplication.appClass = appClass;
        try {
            if (primaryStage == null) {
                if (count.getAndIncrement() == 0) {
                    isStopped = false;
                    try {
                        Application.launch(Interceptor.class, (String[])args);
                    }
                    finally {
                        isStopped = true;
                    }
                    return;
                }
                latch.await();
            }
            Platform.runLater(() -> {
                if (primaryStage.isIconified()) {
                    primaryStage.setIconified(false);
                }
                primaryStage.toFront();
            });
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void launch(String ... args) {
        if (appClass != null) {
            SingletonApplication.launch(appClass, args);
            return;
        }
        try {
            String callingClassName = SingletonApplication.findCallingClassName();
            Class<?> theClass = Class.forName(callingClassName, false, Thread.currentThread().getContextClassLoader());
            if (!Application.class.isAssignableFrom(theClass)) {
                throw new RuntimeException("Error: " + theClass + " is not a subclass of javafx.application.Application");
            }
            Class<?> appClass = theClass;
            SingletonApplication.launch(appClass, args);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isStopped() {
        return isStopped;
    }

    protected static String findCallingClassName() throws ClassNotFoundException {
        StackTraceElement[] cause = Thread.currentThread().getStackTrace();
        boolean foundThisMethod = false;
        String callingClassName = null;
        for (StackTraceElement se : cause) {
            String className = se.getClassName();
            String methodName = se.getMethodName();
            if (foundThisMethod) {
                callingClassName = className;
                break;
            }
            if (!"launch".equals(methodName) || !Application.class.isAssignableFrom(Class.forName(className))) continue;
            foundThisMethod = true;
        }
        if (callingClassName == null) {
            throw new RuntimeException("Error: unable to determine Application class");
        }
        return callingClassName;
    }

    public Stage getPrimaryStage() {
        return primaryStage;
    }

    static {
        count = new AtomicInteger(0);
        latch = new CountDownLatch(1);
        isStopped = true;
    }

    public static class Interceptor
    extends Application {
        private Application app;

        public Interceptor() throws ReflectiveOperationException {
            Constructor<? extends Application> c = appClass.getConstructor(new Class[0]);
            this.app = c.newInstance(new Object[0]);
        }

        public void init() throws Exception {
            this.app.init();
        }

        public void start(Stage stage) throws Exception {
            primaryStage = stage;
            this.app.start(stage);
            latch.countDown();
        }

        public void stop() throws Exception {
            this.app.stop();
        }
    }
}

