/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.scene;

import javafx.animation.Animation;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Parent;
import javafx.scene.Scene;

public class SceneUtil {
    public static void invokeAfterLayout(Parent parent, Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            SceneUtil.invokeAfterLayoutImpl(parent, runnable);
        } else {
            Platform.runLater(() -> SceneUtil.invokeAfterLayoutImpl(parent, runnable));
        }
    }

    private static void invokeAfterLayoutImpl(final Parent parent, final Runnable runnable) {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (runnable == null) {
            throw new NullPointerException();
        }
        final Scene scene = parent.getScene();
        if (scene == null) {
            throw new NullPointerException();
        }
        scene.addPostLayoutPulseListener(new Runnable(){

            @Override
            public void run() {
                if (!parent.isNeedsLayout()) {
                    scene.removePostLayoutPulseListener((Runnable)this);
                    runnable.run();
                }
            }
        });
        Platform.requestNextPulse();
    }

    public static void invokeAfterAnimation(Animation animation, Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            SceneUtil.invokeAfterAnimationImpl(animation, runnable);
        } else {
            Platform.runLater(() -> SceneUtil.invokeAfterAnimationImpl(animation, runnable));
        }
    }

    private static void invokeAfterAnimationImpl(Animation animation, final Runnable runnable) {
        if (animation == null) {
            throw new NullPointerException();
        }
        if (runnable == null) {
            throw new NullPointerException();
        }
        if (animation.getStatus() != Animation.Status.RUNNING) {
            runnable.run();
        } else {
            final ReadOnlyObjectProperty status = animation.statusProperty();
            status.addListener((ChangeListener)new ChangeListener<Animation.Status>(){

                public void changed(ObservableValue<? extends Animation.Status> observable, Animation.Status oldValue, Animation.Status newValue) {
                    if (newValue != Animation.Status.RUNNING) {
                        status.removeListener((ChangeListener)this);
                        runnable.run();
                    }
                }
            });
        }
    }
}

