/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Vector;

public class LogChartPanel
extends Panel
implements Runnable {
    static final int BAR_CHART = 0;
    static final int CIRCLE_CHART = 1;
    static final int LINE_CHART = 2;
    static final Color[] COLOR = new Color[]{new Color(255, 51, 51), new Color(255, 255, 51), new Color(51, 255, 51), new Color(51, 51, 255), new Color(255, 51, 255)};
    private Font rabelTitleFont = new Font("Dialog", 1, 14);
    private Font rabelRateFont = new Font("Dialog", 0, 12);
    private Font scaleFont = new Font("Dialog", 0, 12);
    private Thread thread = null;
    private Vector logs = null;
    private int width = 0;
    private int height = 0;
    private int step = 0;
    private Image offscreen = null;
    private Dimension offscreenDim = null;
    private Graphics offgraphics = null;
    private int chartType = -1;
    private int viewItem = -1;
    private LogTotalizator logTotalizator = null;
    private LogViewer logViewer = null;
    private String lastDate = null;
    private LogReader logReader = null;
    private int skip = 0;

    public LogChartPanel(URL uRL, LogViewer logViewer) {
        this.logViewer = logViewer;
        this.setBackground(Color.white);
        this.logs = new Vector();
        this.logReader = new LogReader(uRL, this.logs);
        this.logReader.start();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LogChartPanel.this.this_mouseClicked(mouseEvent);
            }
        });
    }

    public void setViewItem(int n) {
        if (n == this.viewItem) {
            return;
        }
        this.stop();
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 0;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 1;
                break;
            }
            case 6: {
                n2 = 1;
                break;
            }
            case 7: {
                n2 = 1;
                break;
            }
            default: {
                System.out.println("[ERROR: viewItem]");
            }
        }
        this.logViewer.setChartType(n2);
        this.chartType = n2;
        this.viewItem = n;
        this.start();
    }

    public void setChartType(int n) {
        this.chartType = n;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.logTotalizator == null || this.chartType == 1 ? new Dimension(0, 0) : (this.viewItem == 2 ? new Dimension(0, 0) : (this.logTotalizator.size(this.viewItem) > 30 ? new Dimension(this.getParent().size().width * 3, 0) : (this.logTotalizator.size(this.viewItem) > 20 ? new Dimension(this.getParent().size().width * 2, 0) : new Dimension(0, 0))));
        return dimension;
    }

    public void update(Graphics graphics) {
        Log log;
        int n;
        StringBuffer stringBuffer = new StringBuffer("JAVA\u30d2\u30fc\u30d7: ");
        stringBuffer.append(NumberFormat.getInstance().format(Runtime.getRuntime().totalMemory() / 1024L)).append("KB \u4e2d ");
        stringBuffer.append(NumberFormat.getInstance().format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L)).append("KB \u4f7f\u7528");
        this.logViewer.showStatus(stringBuffer.toString());
        if (this.logTotalizator == null) {
            return;
        }
        ((ScrollPane)this.getParent()).doLayout();
        this.width = this.size().width;
        this.height = this.size().height;
        if (this.offscreen == null || this.width != this.offscreenDim.width || this.height != this.offscreenDim.height) {
            this.offscreen = this.createImage(this.width, this.height);
            this.offscreenDim = this.getSize();
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.offgraphics.setColor(Color.white);
        this.offgraphics.fillRect(0, 0, this.width, this.height);
        if (this.step > this.logs.size()) {
            n = this.logTotalizator.size();
            while (n < this.logs.size()) {
                log = (Log)this.logs.elementAt(n);
                this.logTotalizator.add(log);
                this.lastDate = log.toString();
                ++n;
            }
            if (!this.logReader.isReading()) {
                this.stop();
            }
        } else {
            n = this.logTotalizator.size();
            while (n < this.step) {
                log = (Log)this.logs.elementAt(n);
                this.logTotalizator.add(log);
                this.lastDate = log.toString();
                ++n;
            }
        }
        Vector vector = this.logTotalizator.getCounters(this.viewItem);
        if (this.chartType == 0) {
            int n2 = this.logTotalizator.getMax(this.viewItem);
            this.drawBarChart(this.offgraphics, vector, n2);
        } else if (this.chartType == 1) {
            this.drawCircleChart(this.offgraphics, vector);
        } else if (this.chartType == 2) {
            int n3 = this.logTotalizator.getMax(this.viewItem);
            this.drawLineChart(this.offgraphics, vector, n3);
        } else {
            System.out.println("[ERROR: chartType]");
        }
        this.drawInfo(this.offgraphics);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    private void drawInfo(Graphics graphics) {
        if (this.lastDate == null) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.setFont(new Font("Dialog", 0, 16));
        int n = this.step;
        if (n > this.logs.size()) {
            n = this.logs.size();
        }
        String string = this.lastDate + " (" + n + ")";
        int n2 = graphics.getFontMetrics().stringWidth(string);
        ScrollPane scrollPane = (ScrollPane)this.getParent();
        Point point = scrollPane.getScrollPosition();
        graphics.drawString(string, point.x + scrollPane.size().width / 2 - n2 / 2, 25);
    }

    private void drawBarChart(Graphics graphics, Vector vector, int n) {
        int n2;
        int n3;
        int n4;
        int n5 = n4 = 32;
        int n6 = this.width - n4 * 2;
        int n7 = this.height - n5 * 3;
        graphics.setColor(Color.darkGray);
        graphics.fillRect(n4, n5 / 2, 2, n5 + n7);
        graphics.fillRect(n4 / 2, n5 + n7, n4 + n6, 2);
        graphics.setFont(this.scaleFont);
        FontMetrics fontMetrics = this.getFontMetrics(this.scaleFont);
        int n8 = 0;
        while (n8 < 5) {
            graphics.setColor(Color.lightGray);
            n3 = n4 - 4;
            n2 = n5 + n8 * n7 / 5;
            graphics.drawLine(n3, n2, n4 + n6 + n4 / 2, n2);
            String string = "" + n * (5 - n8) / 5;
            graphics.setColor(Color.black);
            graphics.drawString(string, n3 - fontMetrics.stringWidth(string), n2);
            ++n8;
        }
        if (n == 0) {
            return;
        }
        graphics.setColor(Color.black);
        n3 = n6 / vector.size();
        n2 = this.getFontMetrics(this.rabelTitleFont).getHeight();
        int n9 = 0;
        while (n9 < vector.size()) {
            Counter counter = (Counter)vector.elementAt(n9);
            String string = counter.getName();
            String string2 = " (" + counter.getCount() + ")";
            int n10 = n4 * 3 / 2 + n3 / 2 + n9 * n3;
            int n11 = n5 + n7 + n2 * (n9 % 3 + 1);
            int n12 = this.getFontMetrics(this.rabelTitleFont).stringWidth(string) + this.getFontMetrics(this.rabelRateFont).stringWidth(string2 + "");
            graphics.setFont(this.rabelTitleFont);
            graphics.drawString(string, n10 - n12 / 2, n11);
            graphics.setFont(this.rabelRateFont);
            int n13 = n10 - n12 / 2 + this.getFontMetrics(this.rabelTitleFont).stringWidth(string);
            graphics.drawString(string2, n13, n11);
            graphics.drawLine(n10, n5 + n7 - 3, n10, n5 + n7 + 3);
            ++n9;
        }
        int n14 = n3 / 3 * 2;
        int n15 = 0;
        while (n15 < vector.size()) {
            int n16 = ((Counter)vector.elementAt(n15)).getCount() * n7 / n;
            graphics.setColor(Color.darkGray);
            graphics.fillRect(n4 * 3 / 2 + n3 / 2 + n15 * n3 - n14 * 2 / 5, n5 + n7 - n16 + n14 / 10, n14, n16 - n14 / 10);
            graphics.setColor(Color.blue);
            graphics.fillRect(n4 * 3 / 2 + n3 / 2 + n15 * n3 - n14 / 2, n5 + n7 - n16, n14, n16);
            ++n15;
        }
    }

    private void drawCircleChart(Graphics graphics, Vector vector) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 20;
        int n7 = this.height / 3;
        int n8 = this.width / 2;
        int n9 = this.height / 2;
        int n10 = 10;
        graphics.setColor(new Color(102, 102, 102));
        graphics.fillOval(this.width / 2 - n7 + 5, this.height / 2 - n7 + 5, n7 * 2, n7 * 2);
        graphics.setColor(new Color(102, 102, 102));
        graphics.fillOval(this.width / 2 - n7 - 2, this.height / 2 - n7 - 2, n7 * 2 + 4, n7 * 2 + 4);
        Vector vector2 = new Vector();
        int n11 = 0;
        while (n11 < vector.size()) {
            vector2.addElement(vector.elementAt(n11));
            ++n11;
        }
        int n12 = 1;
        while (n12 < vector2.size() / 9) {
            n12 = n12 * 3 + 1;
        }
        while (n12 > 0) {
            n5 = n12;
            while (n5 < vector2.size()) {
                n4 = n5;
                while (n4 >= n12 && ((Counter)vector2.elementAt(n4 - n12)).getCount() > ((Counter)vector2.elementAt(n4)).getCount()) {
                    Counter counter = (Counter)vector2.elementAt(n4);
                    vector2.setElementAt(vector2.elementAt(n4 - n12), n4);
                    vector2.setElementAt(counter, n4 - n12);
                    n4 -= n12;
                }
                ++n5;
            }
            n12 /= 3;
        }
        n5 = 0;
        n4 = 0;
        while (n4 < vector2.size()) {
            n5 += ((Counter)vector2.elementAt(n4)).getCount();
            ++n4;
        }
        if (n5 == 0) {
            return;
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = COLOR.length - vector2.size() % COLOR.length;
        int n16 = 0;
        while (n16 < vector2.size()) {
            n3 = (vector2.size() - n16 - 1) % COLOR.length;
            if (n16 == 0 && n3 == 0) {
                n3 = 1;
            }
            graphics.setColor(COLOR[n3]);
            n2 = (n13 += ((Counter)vector2.elementAt(n16)).getCount()) * 360 / n5;
            graphics.fillArc(this.width / 2 - n7, this.height / 2 - n7, n7 * 2, n7 * 2, 90 + n14, n2 - n14);
            n14 = n2;
            ++n16;
        }
        n3 = 0;
        n13 = 0;
        n2 = 0;
        while (n2 < vector2.size()) {
            n = ((Counter)vector2.elementAt(n2)).getCount();
            if (n13 + n / 2 > n5 / 2) {
                ++n3;
            }
            n13 += n;
            ++n2;
        }
        n = n3 != 0 ? this.height / n3 : this.height;
        int n17 = vector2.size() != n3 ? this.height / (vector2.size() - n3) : this.height;
        n13 = 0;
        int n18 = 0;
        while (n18 < vector2.size()) {
            Counter counter = (Counter)vector2.elementAt(n18);
            String string = counter.getName();
            int n19 = counter.getCount();
            int n20 = n19 * 1000 / n5;
            String string2 = " (" + n20 / 10 + "." + n20 % 10 + "%)";
            double d = (double)(n13 + n19 / 2) / (double)n5 * Math.PI * 2.0;
            boolean bl = n13 + n19 / 2 > n5 / 2;
            n13 += n19;
            int n21 = n8 + (int)(Math.cos(d + 1.5707963267948966) * (double)n7 * 0.7);
            int n22 = n9 - (int)(Math.sin(d + 1.5707963267948966) * (double)n7 * 0.7);
            graphics.setColor(Color.darkGray);
            graphics.fillOval(n21 - 2, n22 - 2, 4, 4);
            int n23 = this.getFontMetrics(this.rabelTitleFont).getHeight() / 2;
            int n24 = n8 + n7 * 11 / 10 * (bl ? 1 : -1);
            int n25 = bl ? this.width - n10 : n10;
            int n26 = bl ? n * (vector2.size() - (n18 + 1)) + n / 2 + n23 / 2 + 2 : n17 * n18 + n17 / 2 + n23 / 2 + 2;
            graphics.setColor(Color.black);
            graphics.drawLine(n21, n22, n24, n26);
            graphics.drawLine(n24, n26, n25, n26);
            int n27 = this.getFontMetrics(this.rabelTitleFont).stringWidth(string);
            int n28 = this.getFontMetrics(this.rabelRateFont).stringWidth(string2);
            int n29 = n26 - 1;
            if (bl) {
                graphics.setFont(this.rabelTitleFont);
                graphics.drawString(string, n25 - n27 - n28, n29);
                graphics.setFont(this.rabelRateFont);
                graphics.drawString(string2, n25 - n28, n29);
            } else {
                graphics.setFont(this.rabelTitleFont);
                graphics.drawString(string, n25, n29);
                graphics.setFont(this.rabelRateFont);
                graphics.drawString(string2, n25 + n27, n29);
            }
            ++n18;
        }
    }

    private void drawLineChart(Graphics graphics, Vector vector, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n6 = 32;
        int n8 = this.width - n6 * 2;
        int n9 = this.height - n7 * 3;
        graphics.setColor(Color.darkGray);
        graphics.fillRect(n6, n7 / 2, 2, n7 + n9);
        graphics.fillRect(n6 / 2, n7 + n9, n6 + n8, 2);
        graphics.setFont(this.scaleFont);
        FontMetrics fontMetrics = this.getFontMetrics(this.scaleFont);
        int n10 = 0;
        while (n10 < 5) {
            graphics.setColor(Color.lightGray);
            n5 = n6 - 4;
            n4 = n7 + n10 * n9 / 5;
            graphics.drawLine(n5, n4, n6 + n8 + n6 / 2, n4);
            String string = "" + n * (5 - n10) / 5;
            graphics.setColor(Color.black);
            graphics.drawString(string, n5 - fontMetrics.stringWidth(string), n4);
            ++n10;
        }
        if (n == 0) {
            return;
        }
        graphics.setColor(Color.black);
        n5 = n8 / vector.size();
        n4 = this.getFontMetrics(this.rabelTitleFont).getHeight();
        int n11 = 0;
        while (n11 < vector.size()) {
            Counter counter = (Counter)vector.elementAt(n11);
            String string = counter.getName();
            String string2 = " (" + counter.getCount() + ")";
            n3 = n6 * 3 / 2 + n5 / 2 + n11 * n5;
            n2 = n7 + n9 + n4 * (n11 % 3 + 1);
            int n12 = this.getFontMetrics(this.rabelTitleFont).stringWidth(string) + this.getFontMetrics(this.rabelRateFont).stringWidth(string2 + "");
            graphics.setFont(this.rabelTitleFont);
            graphics.drawString(string, n3 - n12 / 2, n2);
            graphics.setFont(this.rabelRateFont);
            int n13 = n3 - n12 / 2 + this.getFontMetrics(this.rabelTitleFont).stringWidth(string);
            graphics.drawString(string2, n13, n2);
            graphics.drawLine(n3, n7 + n9 - 3, n3, n7 + n9 + 3);
            ++n11;
        }
        int n14 = n5 / 2;
        int n15 = n9 - ((Counter)vector.elementAt(0)).getCount() * n9 / n;
        int n16 = 1;
        while (n16 < vector.size()) {
            graphics.setColor(new Color(0, 0, 102));
            n3 = n5 / 2 + n16 * n5;
            n2 = n9 - ((Counter)vector.elementAt(n16)).getCount() * n9 / n;
            graphics.drawLine(n6 * 3 / 2 + n14, n7 + n15, n6 * 3 / 2 + n3, n7 + n2);
            graphics.fillOval(n6 * 3 / 2 + n14 - 4, n7 + n15 - 4, 8, 8);
            graphics.setColor(Color.white);
            graphics.fillOval(n6 * 3 / 2 + n14 - 2, n7 + n15 - 2, 4, 4);
            n14 = n3;
            n15 = n2;
            ++n16;
        }
        graphics.setColor(new Color(0, 0, 102));
        graphics.fillOval(n6 * 3 / 2 + n14 - 4, n7 + n15 - 4, 8, 8);
        graphics.setColor(Color.white);
        graphics.fillOval(n6 * 3 / 2 + n14 - 2, n7 + n15 - 2, 4, 4);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void start() {
        if (this.thread == null) {
            this.skip = 1;
            this.step = 1;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        this.logTotalizator = new LogTotalizator();
        while (this.thread == thread) {
            try {
                Thread.sleep(30L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
            this.step += this.skip;
        }
    }

    public void stop() {
        this.thread = null;
        System.gc();
    }

    void this_mouseClicked(MouseEvent mouseEvent) {
        this.skip *= 2;
    }
}

