/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor;

import java.util.HashMap;
import java.util.Map;
import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.accessor.DataAccessContext;
import jp.co.cybec.cb3.accessor.DataAccessContextLifeCycle;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigurationRuntimeException;
import jp.co.cybec.cb3.util.CB3BeanFactory;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAccessContextImpl
implements DataAccessContext,
DataAccessContextLifeCycle {
    private Map<String, Accessor> dataAccessors = new HashMap<String, Accessor>();
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");

    public DataAccessContextImpl(Map<String, Accessor> dataAccessors) throws AccessorUnknownException {
        this.dataAccessors = dataAccessors;
        try {
            for (String key : dataAccessors.keySet()) {
                ((AccessorsLifeCycle)((Object)dataAccessors.get(key))).initialize(key);
            }
        }
        catch (RuntimeException e) {
            if (e instanceof ConfigurationRuntimeException) {
                throw e;
            }
            throw new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.001", "CB3.ACCESSOR.002"), e);
        }
    }

    @Override
    public Accessor lookup(String key) {
        if (this.dataAccessors.get(key) == null) {
            throw new ConfigFileDefinitionException(MESSAGE.getErrorMessage("ACCESSOR.002", "CB3.ACCESSOR.001", CB3BeanFactory.getInstance().getApplicationContextFilePath(), key));
        }
        return this.dataAccessors.get(key);
    }

    @Override
    public void release() {
        for (String key : this.dataAccessors.keySet()) {
            ((AccessorsLifeCycle)((Object)this.dataAccessors.get(key))).release();
        }
    }
}

