/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess;

import java.math.BigDecimal;
import java.util.Date;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldReaderFormatable;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.DateUtil;
import jp.co.cybec.cb3.util.NumberUtil;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordFieldReaderFormat
implements RecordFieldReaderFormatable {
    private static final Log LOG = LogFactory.getLog(RecordFieldReaderFormat.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String filepath = null;
    private String field = null;

    public RecordFieldReaderFormat(String filepath, String field) {
        this.filepath = filepath;
        this.field = field;
    }

    public String format(String pattern, String type, String data) throws DataFormatException {
        String retValue = null;
        if (data == null || data.trim().length() == 0) {
            return data;
        }
        if (pattern == null || pattern.length() == 0) {
            return data;
        }
        if (type == null || !type.equalsIgnoreCase("number") && !type.equalsIgnoreCase("date")) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.001", "CB3.ACCESSOR.FILEACCESS.008", this.filepath, this.field, type));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            if (type.equalsIgnoreCase("number")) {
                BigDecimal bNum = NumberUtil.parseBigDecimal(pattern, data);
                retValue = NumberUtil.numberToString(bNum, NumberUtil.getFractionDigits(pattern));
            } else {
                Date date = DateUtil.parseDate(data, pattern);
                retValue = DateUtil.formatDate(date);
            }
        }
        catch (Exception e) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.002", "CB3.ACCESSOR.FILEACCESS.007", this.field, data, pattern));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        return retValue;
    }

    public String trim(String algin, String padding, String data) throws DataFormatException {
        String retValue = null;
        if (data == null) {
            return null;
        }
        if (algin == null || algin.trim().length() == 0 || padding == null || padding.length() == 0) {
            return data;
        }
        if (!algin.equalsIgnoreCase("left") && !algin.equalsIgnoreCase("right")) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.003", "CB3.ACCESSOR.FILEACCESS.011", this.filepath, this.field, algin));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        if (padding.getBytes().length > 1) {
            DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.004", "CB3.ACCESSOR.FILEACCESS.012", this.filepath, this.field, padding));
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        char paddingChar = padding.charAt(0);
        if (algin.equalsIgnoreCase("left")) {
            int index = data.length();
            int i = data.length() - 1;
            while (i >= 0) {
                if (data.charAt(i) != paddingChar) break;
                index = i--;
            }
            retValue = data.substring(0, index);
        } else {
            int index = -1;
            int i = 0;
            while (i <= data.length() - 1) {
                if (data.charAt(i) != paddingChar) break;
                index = i++;
            }
            retValue = data.substring(index + 1);
        }
        return retValue;
    }
}

