/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLAttribute;
import jp.co.cybec.cb3.accessor.fileaccess.xml.XMLElement;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.BadXmlGrammerException;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

public class XMLPath {
    private static final Log LOG = LogFactory.getLog(XMLPath.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");
    private String key = null;
    private String path = null;
    private XmlCursor cursor = null;
    private List<XmlCursor> childCursorList = new ArrayList<XmlCursor>();
    private int row = 0;

    protected XMLPath() {
    }

    protected XMLPath(String key, XmlObject xml, String path) throws BadXmlGrammerException, AccessorUnknownException {
        this.key = key;
        this.path = path;
        try {
            this.cursor = xml.newCursor();
        }
        catch (Exception e) {
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.036", "CB3.ACCESSOR.FILEACCESS.006", key), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            this.cursor.selectPath(path);
        }
        catch (Exception e) {
            BadXmlGrammerException ex = new BadXmlGrammerException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.037", "CB3.ACCESSOR.FILEACCESS.XML.002", key, path), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    protected XMLPath(String key, XmlCursor cursor, String path) {
        this.key = key;
        this.path = path;
        this.cursor = cursor;
    }

    public XMLElement next() throws AccessorUnknownException {
        block9: {
            ++this.row;
            for (XmlCursor childCursor : this.childCursorList) {
                childCursor.dispose();
            }
            this.childCursorList.clear();
            if (this.cursor.hasNextSelection()) break block9;
            return null;
        }
        try {
            this.cursor.toNextSelection();
            this.cursor.push();
            XMLElement element = new XMLElement(this.cursor.getName().getLocalPart(), this.key, this.path);
            element.setString(this.cursor.getTextValue());
            if (this.cursor.toFirstAttribute()) {
                do {
                    String name = this.cursor.getName().getLocalPart();
                    element.putAttribute(new XMLAttribute(name, this.cursor.getTextValue(), element.getName(), this.key, this.path));
                } while (this.cursor.toNextAttribute());
            }
            this.cursor.pop();
            if (LOG.isDebugEnabled()) {
                StringBuilder elementMessage = new StringBuilder();
                elementMessage.append(element.getName());
                elementMessage.append("=");
                elementMessage.append(element.getString());
                StringBuilder attributeMessage = new StringBuilder();
                int index = 0;
                for (Map.Entry<String, XMLAttribute> entry : element.getAttributes().entrySet()) {
                    if (++index > 1) {
                        attributeMessage.append(", ");
                    }
                    attributeMessage.append(entry.getKey());
                    attributeMessage.append("=");
                    attributeMessage.append(entry.getValue().getString());
                }
                LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.FILEACCESS.XML.008", this.key, this.path, this.row, elementMessage.toString(), attributeMessage.toString()));
            }
            return element;
        }
        catch (Exception e) {
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.038", "CB3.ACCESSOR.FILEACCESS.006", this.key), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
    }

    public XMLPath selectChildPath(String path) throws BadXmlGrammerException, AccessorUnknownException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)MESSAGE.getMessage("CB3.ACCESSOR.FILEACCESS.XML.007", this.key, path));
        }
        XmlCursor childCursor = null;
        try {
            childCursor = this.cursor.newCursor();
        }
        catch (Exception e) {
            AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.039", "CB3.ACCESSOR.FILEACCESS.006", this.key), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        try {
            childCursor.selectPath(path);
        }
        catch (Exception e) {
            BadXmlGrammerException ex = new BadXmlGrammerException(MESSAGE.getErrorMessage("ACCESSOR.FILEACCESS.XML.040", "CB3.ACCESSOR.FILEACCESS.XML.002", this.key, path), e);
            LOG.info((Object)ex.getMessage(), (Throwable)((Object)ex));
            throw ex;
        }
        this.childCursorList.add(childCursor);
        return new XMLPath(this.key, childCursor, path);
    }
}

