/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.aspect;

import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;

public class LoggingAspect {
    private static final Log LOG = LogFactory.getLog(LoggingAspect.class);
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");

    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        String className = pjp.getTarget().getClass().getName();
        String methodName = pjp.getSignature().getName();
        long beforeTime = System.currentTimeMillis();
        LOG.info((Object)MESSAGE.getMessage("CB3.ASPECT.001", className, methodName));
        if (LOG.isDebugEnabled()) {
            Object[] args = pjp.getArgs();
            LOG.debug((Object)MESSAGE.getMessage("CB3.ASPECT.005", this.formatArguments(args)));
        }
        Object returnCode = pjp.proceed();
        long afterTime = System.currentTimeMillis();
        long execTime = afterTime - beforeTime;
        LOG.info((Object)MESSAGE.getMessage("CB3.ASPECT.002", className, methodName, returnCode, execTime));
        return returnCode;
    }

    private String formatArguments(Object[] args) {
        if (args == null || args.length == 0) {
            return "";
        }
        StringBuilder argsMessage = new StringBuilder();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object arg = objectArray[n2];
            argsMessage.append(arg.toString());
            argsMessage.append(", ");
            ++n2;
        }
        if (argsMessage.length() > 0 && argsMessage.lastIndexOf(", ") == argsMessage.length() - 2) {
            argsMessage.delete(argsMessage.length() - 2, argsMessage.length());
        }
        return argsMessage.toString();
    }
}

