/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.container.provider;

import jp.co.cybec.cb3.container.provider.ServiceProvider;
import jp.co.cybec.cb3.exception.ServiceProviderCreationException;
import jp.co.cybec.cb3.util.CB3BeanFactory;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

public class ServiceProviderFactory {
    private static ServiceProviderFactory factory = new ServiceProviderFactory();
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");

    public static ServiceProviderFactory getInstance() {
        return factory;
    }

    private ServiceProviderFactory() {
    }

    public ServiceProvider getServiceProvider(String beanId) {
        CB3BeanFactory beanFactory = CB3BeanFactory.getInstance();
        try {
            return (ServiceProvider)beanFactory.getBean(beanId);
        }
        catch (RuntimeException e) {
            Object[] param = new Object[]{beanFactory.getApplicationContextFilePath(), beanId};
            throw new ServiceProviderCreationException(MESSAGE.getErrorMessage("CONTAINER.PROVIDER.001", "CB3.CONTAINER.PROVIDER.002", param), e);
        }
    }
}

