/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.container.provider;

import java.text.SimpleDateFormat;
import java.util.Date;
import jp.co.cybec.cb3.container.provider.ServiceProvider;
import jp.co.cybec.cb3.container.provider.ServiceProviderFactory;
import jp.co.cybec.cb3.container.service.Service;
import jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException;
import jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import jp.co.cybec.cb3.util.ApplicationExiterDelegater;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import jp.co.cybec.cb3.util.logging.LogMessageIdentifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceProviderImpl
implements ServiceProvider {
    private static final Log LOG = LogFactory.getLog(ServiceProviderImpl.class);
    private static final String SERVICE_KEY = "-ServiceName";
    private Service service = null;
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");

    public static void main(String[] args) {
        try {
            RuntimeArgumentsAnalyzer analyzer = ServiceProviderImpl.analyzeArguments(args);
            String beanId = analyzer.getReservedParameter(SERVICE_KEY);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            LogMessageIdentifier.setJobProcessId(String.valueOf(beanId) + sdf.format(new Date()));
            LogMessageIdentifier.setServiceId(beanId);
            ServiceProvider provider = ServiceProviderFactory.getInstance().getServiceProvider(beanId);
            int resultCode = provider.callService(new ServiceParameters(), analyzer.getRuntimeParameters());
            ApplicationExiterDelegater.getInstance().exit(resultCode);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeArgumentsAnalyzeException) {
                String helpMessage = "ServiceProviderImpl [-ServiceName \u30b5\u30fc\u30d3\u30b9\u30d7\u30ed\u30d0\u30a4\u30c0\u306ebeanid] [-AppParam \u30ad\u30fc=\u5024 \u30ad\u30fc=\u5024 ...]";
                LOG.error((Object)MESSAGE.getErrorMessage("CONTAINER.PROVIDER.002", "CB3.CONTAINER.PROVIDER.003", helpMessage));
            }
            LOG.error((Object)t.getMessage(), t);
            ApplicationExiterDelegater.getInstance().exit(9);
        }
    }

    private static RuntimeArgumentsAnalyzer analyzeArguments(String[] args) {
        RuntimeArgumentsAnalyzer analyzer = new RuntimeArgumentsAnalyzer(args, SERVICE_KEY);
        if (analyzer.getReservedParameter(SERVICE_KEY) == null) {
            throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage("CONTAINER.PROVIDER.003", "CB3.CONTAINER.PROVIDER.001", SERVICE_KEY));
        }
        return analyzer;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public int callService(ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) {
        return this.service.callService(serviceParameters, runtimeParameters);
    }
}

