/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cybec.cb3.session;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeArgumentsAnalyzer {
    public static final String APP_PARAM_KEY = "-AppParams";
    private RuntimeParameters runtimeParameters = null;
    private Map<String, String> reservedParameters = new HashMap<String, String>();
    private static final LogMessageFactory MESSAGE = new LogMessageFactory("logMessage");

    public RuntimeArgumentsAnalyzer(String[] args, String ... parameterKeys) {
        this.analizeParameters(args, parameterKeys);
    }

    public RuntimeParameters getRuntimeParameters() {
        return this.runtimeParameters;
    }

    public String getReservedParameter(String key) {
        return this.reservedParameters.get(key);
    }

    private void analizeParameters(String[] args, String ... reservedKeys) {
        List<String> reservedKeyList = Arrays.asList(reservedKeys);
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (reservedKeyList.contains(key)) {
                if (iterator.hasNext()) {
                    if (this.reservedParameters.containsKey(key)) {
                        throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage("SESSION.001", "CB3.SESSION.001", key));
                    }
                    this.reservedParameters.put(key, iterator.next());
                    continue;
                }
                throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage("SESSION.002", "CB3.SESSION.002", key));
            }
            if (APP_PARAM_KEY.equals(key)) break;
            throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage("SESSION.003", "CB3.SESSION.003", key));
        }
        this.analyzeRuntimeParameters(iterator);
    }

    private void analyzeRuntimeParameters(Iterator<String> iterator) {
        HashMap<String, String> runtimeParameterMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String runtimeParameter = iterator.next();
            int splitPoint = runtimeParameter.indexOf(61);
            if (splitPoint < 0) {
                throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage("SESSION.004", "CB3.SESSION.004", runtimeParameter));
            }
            String key = runtimeParameter.substring(0, splitPoint);
            String value = runtimeParameter.substring(splitPoint + 1);
            runtimeParameterMap.put(key, value);
        }
        this.runtimeParameters = new RuntimeParameters(runtimeParameterMap);
    }
}

