/*
 * DataAccessContextImpl.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor;

import java.util.HashMap;
import java.util.Map;

import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigurationRuntimeException;
import jp.co.cybec.cb3.util.CB3BeanFactory;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

/**
 * f[^ANZXReLXg̎NXB<br>
 * T[rXŎgpf[^ANZbTƁAL[iݒt@Cj̑gݍ킹MapɕێA
 * lookup\bhŕԂ܂B
 * f[^ANZbT́ASpringɂ萶Af[^ANZXReLXgɒ܂B
 * @author Naoko Sugimoto
 */
public class DataAccessContextImpl implements DataAccessContext, DataAccessContextLifeCycle {

	/** f[^ANZbT */
	private Map<String, Accessor> dataAccessors = new HashMap<String, Accessor>();

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * RXgN^B<br>
	 * f[^ANZbT܂B
	 * @param dataAccessors f[^ANZbTƁAL[iݒt@Cjgݍ킹MapB
	 * @throws AccessorUnknownException ANZbT̏ŗ\ȂOꍇɔB
	 */
	public DataAccessContextImpl(Map<String, Accessor> dataAccessors) throws AccessorUnknownException {
		this.dataAccessors = dataAccessors;

		try {
			for (String key : dataAccessors.keySet()) {
				// AccessoȑBXMLt@C̓ǂݍ݂sB
				((AccessorsLifeCycle)dataAccessors.get(key)).initialize(key);
			}
		} catch (RuntimeException e) {
			if (e instanceof ConfigurationRuntimeException) {
				throw e;
			} else {
				// \ȂOꍇɁAANZbT̏ŔƂƂ悤ɂ邽ߒuB
				throw new AccessorUnknownException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_001, LogMessageConstant.CB3_ACCESSOR_002), e);
			}
		}
	}

	/**
	 * f[^ANZbTԂ܂B
	 * @param key ANZbTL[
	 * @return f[^ANZbT
	 */
	public Accessor lookup(String key) {

		if (dataAccessors.get(key) == null) {
			throw new ConfigFileDefinitionException(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_002,
							LogMessageConstant.CB3_ACCESSOR_001,
							CB3BeanFactory.getInstance().getApplicationContextFilePath(),
							key
					)
			);
		}
		return dataAccessors.get(key);
	}

	/**
	 * ANZbTReLXg̏IłB<br>
	 * f[^ANZbT̏IĂяo܂B
	 */
	public void release() {
		for (String key : dataAccessors.keySet()) {
			// AccessoȑIBYꂽResultSetXg[closeȂǂsB
			((AccessorsLifeCycle)dataAccessors.get(key)).release();
		}
	}
}
