/*
 * DBAccessor.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import org.springframework.dao.DataAccessException;

import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.DataFileNoSuchSqlIdException;

/**
 * DBf[^փANZXC^tF[XNXB<br>
 * ̃C^tF[X̊e\bhł{@link org.springframework.dao.DataAccessException}X[ꍇ܂B<br>
 * {@link org.springframework.dao.DataAccessException}́ASpring FrameworkONXŁA
 * SQL̃G[R[hɂA̗ONXpNXX[܂B<br>
 * ۂɃX[ONX͎sf[^x[XSQL̃G[R[hɂς܂B<br>
 * <br>
 * L̕\Ƀf[^x[X̔OƑΉG[R[h܂B
 *
 * <br>
 * <br>Oracle
 * <table border="1">
 * <tr>
 * <th>O</th>
 * <th>G[R[h</th>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.jdbc.BadSqlGrammarException}</td>
 * <td>900,903,904,917,936,942,17006</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.jdbc.InvalidResultSetAccessException}</td>
 * <td>17003</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataAccessResourceFailureException}</td>
 * <td>17002,17447</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataIntegrityViolationException}</td>
 * <td>1,1400,1722,2291,2292</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.CannotAcquireLockException}</td>
 * <td>54</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.CannotSerializeTransactionException}</td>
 * <td>8177</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DeadlockLoserDataAccessException}</td>
 * <td>60</td>
 * </tr>
 * </table>
 *
 * <br>DB2
 * <table border="1">
 * <tr>
 * <th>O</th>
 * <th>G[R[h</th>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.jdbc.BadSqlGrammarException}</td>
 * <td>-007,-029,-097,-104,-109,-115,-128,-199,-204,-206,-301,-408,-441,-491</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataAccessResourceFailureException}</td>
 * <td>-904,-971</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataIntegrityViolationException}</td>
 * <td>-407,-530,-531,-532,-543,-544,-545,-603,-667,-803</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DeadlockLoserDataAccessException}</td>
 * <td>-911,-913</td>
 * </tr>
 * </table>
 *
 * <br>MySQL
 * <table border="1">
 * <tr>
 * <th>O</th>
 * <th>G[R[h</th>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.jdbc.BadSqlGrammarException}</td>
 * <td>1054,1064,1146</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataAccessResourceFailureException}</td>
 * <td>1</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataIntegrityViolationException}</td>
 * <td>630,839,840,893,1062,1169,1215,1216,1217,1451,1452,1557</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.CannotAcquireLockException}</td>
 * <td>1205</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DeadlockLoserDataAccessException}</td>
 * <td>1213</td>
 * </tr>
 * </table>
 *
 * <br>PostgreSQL
 * <table border="1">
 * <tr>
 * <th>O</th>
 * <th>G[R[h</th>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.jdbc.BadSqlGrammarException}</td>
 * <td>03000,42000,42601,42602,42622,42804,42P01</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataAccessResourceFailureException}</td>
 * <td>53000,53100,53200,53300</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataIntegrityViolationException}</td>
 * <td>23000,23502,23503,23505,23514</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.CannotAcquireLockException}</td>
 * <td>55P03</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.CannotSerializeTransactionException}</td>
 * <td>40001</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DeadlockLoserDataAccessException}</td>
 * <td>40P01</td>
 * </tr>
 * </table>
 *
 * <br>SQL Server
 * <table border="1">
 * <tr>
 * <th>O</th>
 * <th>G[R[h</th>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.jdbc.BadSqlGrammarException}</td>
 * <td>156,170,207,208</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.PermissionDeniedDataAccessException}</td>
 * <td>229</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DataIntegrityViolationException}</td>
 * <td>544,2601,2627,8114,8115</td>
 * </tr>
 * <tr>
 * <td>{@link org.springframework.dao.DeadlockLoserDataAccessException}</td>
 * <td>1205</td>
 * </tr>
 * </table>
 *
 * @author Lijuan Sun
 */
public interface DBAccessor extends Accessor {

	/**
	 * f[^擾郁\bhB
	 *
	 * @param key SQLID
	 * @return ʂ̃R[hZbgێDBRecordReader
	 * @throws DataFileNoSuchSqlIdException keyɑΉSQLȂꍇB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 */
	DBRecordReader select(String key) throws DataFileNoSuchSqlIdException, DataAccessException;

	/**
	 * f[^擾郁\bhB
	 *
	 * @param key SQLID
	 * @param parameter SQL̈
	 * @return ʂ̃R[hZbgێDBRecordReader
	 * @throws DataFileNoSuchSqlIdException keyɑΉSQLȂꍇB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 */
	DBRecordReader select(String key, DBQueryParameterMap parameter)
			throws DataFileNoSuchSqlIdException, DataAccessException;

	/**
	 * f[^XV郁\bhB
	 *
	 * @param key SQLID
	 * @return 
	 * @throws DataFileNoSuchSqlIdException keyɑΉSQLȂꍇB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 * @throws AccessorUnknownException ɉ炩̃G[ꍇB
	 */
	int update(String key) throws DataFileNoSuchSqlIdException, DataAccessException,
			AccessorUnknownException;

	/**
	 * f[^XV郁\bhB
	 *
	 * @param key SQLID
	 * @param parameter SQL̈
	 * @return 
	 * @throws DataFileNoSuchSqlIdException keyɑΉSQLȂꍇB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 * @throws AccessorUnknownException ɉ炩̃G[ꍇB
	 */
	int update(String key, DBQueryParameterMap parameter) throws DataFileNoSuchSqlIdException,
			DataAccessException, AccessorUnknownException;

	/**
	 * f[^}郁\bhB
	 *
	 * @param key SQLID
	 * @return 
	 * @throws DataFileNoSuchSqlIdException keyɑΉSQLȂꍇB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 * @throws AccessorUnknownException ɉ炩̃G[ꍇB
	 */
	int insert(String key) throws DataFileNoSuchSqlIdException, DataAccessException,
			AccessorUnknownException;

	/**
	 * f[^}郁\bhB
	 *
	 * @param key SQLID
	 * @param parameter SQL̈
	 * @return 
	 * @throws DataFileNoSuchSqlIdException keyɑΉSQLȂꍇB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 * @throws AccessorUnknownException ɉ炩̃G[ꍇB
	 */
	int insert(String key, DBQueryParameterMap parameter) throws DataFileNoSuchSqlIdException,
			DataAccessException, AccessorUnknownException;

	/**
	 * f[^폜郁\bhB
	 *
	 * @param key SQLID
	 * @return 
	 * @throws DataFileNoSuchSqlIdException keyɑΉSQLȂꍇB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 * @throws AccessorUnknownException ɉ炩̃G[ꍇB
	 */
	int delete(String key) throws DataFileNoSuchSqlIdException, DataAccessException,
			AccessorUnknownException;

	/**
	 * f[^폜郁\bhB
	 *
	 * @param key SQLID
	 * @param parameter SQL̈
	 * @return 
	 * @throws DataFileNoSuchSqlIdException keyɑΉSQLȂꍇB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 * @throws AccessorUnknownException ɉ炩̃G[ꍇB
	 */
	int delete(String key, DBQueryParameterMap parameter) throws DataFileNoSuchSqlIdException,
			DataAccessException, AccessorUnknownException;

}
