/*
 * DBAccessorImpl.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;


import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;

import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileNoSuchSqlIdException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;


/**
 * f[^x[XANZbTNXB<br>
 * ̃NX̃IuWFNgłf[^x[XANZbT́A
 * ݒt@C̓eɏ]ăt[[Nɂ萶A
 * ob`T[rXɒ񋟂܂B
 * ob`T[rX́Af[^x[XANZbTgp
 * f[^x[X̃f[^ɃANZX邱Ƃł܂B
 * @author Lijuan Sun
 */
public class DBAccessorImpl extends CB3JdbcDaoSupport implements DBAccessor,AccessorsLifeCycle {

	/** O */
	private static final Log LOG = LogFactory.getLog(DBAccessorImpl.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** ^O[t@C */
	private static final String RULE_FILE = "dbaccessConfigRule.xml";
	/** NG[pSQLLbV */
	private Map<String, String> selectSqlCache = new HashMap<String,String>();
	/** CT[gpSQLLbV */
	private Map<String, String> insertSqlCache = new HashMap<String,String>();
	/** XVpSQLLbV */
	private Map<String, String> updateSqlCache = new HashMap<String,String>();
	/** 폜pSQLLbV */
	private Map<String, String> deleteSqlCache = new HashMap<String,String>();
	/** R~bgPʂLbV */
	private Map<String, String> commitLimitCountMap = new HashMap<String,String>();
	/** JEgLbV */
	private Map<String, Integer> commitCountMap = new HashMap<String,Integer>();

	/**
	 *
	 * f[^ANZXݒt@CǂݍށB
	 *
	 * @param key String ݒt@C
	 * @throws ConfigFileNotFoundException ݒt@C݂Ȃꍇɔ܂B
	 * @throws ConfigFileDefinitionException ݒt@C̊ԈႢɂ蔭܂B
	 * @throws ConfigFileIOException ݒt@CǂݍݎIOG[ɂ蔭܂B
	 * @throws ConfigFileParseException ݒt@CXMLt@C͂sɔ܂B
	 */
	public void initialize(String key)
			throws ConfigFileNotFoundException, ConfigFileDefinitionException,
			ConfigFileIOException, ConfigFileParseException {

		// keyf[^ANZXݒt@Cǂݍ
		DBAccessConfig info = (DBAccessConfig) ConfigurationLoader
							.load(RULE_FILE, key);

		// LbV
		for (SelectSql sql : info.getSelectSql()) {
			// NG[pSQLLbV
			selectSqlCache.put(sql.getId(), sql.getSelect());
		}

		for (UpdateSql sql : info.getUpdateSql()) {
			// R~bgPʂLbV
			commitLimitCountMap.put(sql.getId(), sql.getCommitLimitCount());
			// XVpSQLLbV
			updateSqlCache.put(sql.getId(), sql.getUpdate());
		}

		for (InsertSql sql : info.getInsertSql()) {
			// R~bgPʂLbV
			commitLimitCountMap.put(sql.getId(), sql.getCommitLimitCount());
			//CT[gpSQLLbV
			insertSqlCache.put(sql.getId(),sql.getInsert());
		}

		for (DeleteSql sql : info.getDeleteSql()) {
			// R~bgPʂLbV
			commitLimitCountMap.put(sql.getId(), sql.getCommitLimitCount());
			// 폜pSQLLbV
			deleteSqlCache.put(sql.getId(), sql.getDelete());
		}
	}

	/**
	 *
	 * ㏈B
	 *
	 */
	public void release() {

		// resultSetAXe[ggA
		// RlNVN[Y
		getCB3JdbcTemplate().close();
		// LbVNA
		selectSqlCache.clear();
		updateSqlCache.clear();
		insertSqlCache.clear();
		deleteSqlCache.clear();
		commitLimitCountMap.clear();
		commitCountMap.clear();
	}

	/**
	 * {@inheritDoc}
	 */
	public DBRecordReader select(String key, DBQueryParameterMap parameter)
			throws DataFileNoSuchSqlIdException, DataAccessException {

		// SQL擾
		String sql = selectSqlCache.get(key);
		// SQLNULLꍇ
		if (sql == null || "".equals(sql)) {
			// DataFileNoSuchSqlIdException쐬
			DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_006,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_011, key, "select"));
			//Oo
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}

		// p[^tȂꍇANG[s
		ResultSet rs = getCB3JdbcTemplate().query(sql, parameter);

		// ʂݒ肷
		JdbcRecordReader recordReader = new JdbcRecordReader(rs, sql, parameter);
		// ʂ߂
		return recordReader;
	}

	/**
	 * {@inheritDoc}
	 */
	public DBRecordReader select(String key)
		throws DataFileNoSuchSqlIdException, DataAccessException {

		// SQL擾
		String sql = selectSqlCache.get(key);
		// SQLNULLꍇ
		if (sql == null || "".equals(sql)) {
			// DataFileNoSuchSqlIdException쐬
			DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_007,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_011, key, "select"));
			//Oo
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}

		// p[^tȂꍇ
		ResultSet rs = getCB3JdbcTemplate().query(sql);

		// ʂݒ肷
		JdbcRecordReader recordReader = new JdbcRecordReader(rs, sql);
		// ʂ߂
		return recordReader;
	}

	/**
	 * {@inheritDoc}
	 */
	public int update(String key, DBQueryParameterMap parameter)
		throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {

		// SQL擾
		String sql = updateSqlCache.get(key);
		// SQLNULLꍇ
		if (sql == null || "".equals(sql)) {
			// DataFileNoSuchSqlIdException쐬
			DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_008,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_011, key, "update"));
			//Oo
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}

		try {
			// p[^tꍇ
			int rtCnt = getCB3JdbcTemplate().update(sql, parameter);
			// R~bg
			divideCommit(key,rtCnt);

			// ʂ߂
			return rtCnt;

		} catch (DataAccessException e) {
			// DataAccessException̏ꍇ͂̂܂܃X[܂B
			throw e;

		} catch (Exception e) {
			// ̑G[ꍇAAccessorUnknownException쐬
			Object[] msg = {
					sql,
					parameter
				};
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_DBACCESS_009,
					LogMessageConstant.CB3_ACCESSOR_DBACCESS_009, msg), e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public int update(String key)
		throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {

		// SQL擾
		String sql = updateSqlCache.get(key);
		// SQLNULLꍇ
		if (sql == null || "".equals(sql)) {
			// DataFileNoSuchSqlIdException쐬
			DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_010,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_011, key, "update"));
			//Oo
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}

		try {
			// p[^tȂꍇ
			int rtCnt = getCB3JdbcTemplate().update(sql);
			// R~bg
			divideCommit(key,rtCnt);

			// ʂ߂
			return	rtCnt;

		} catch (DataAccessException e) {
			// DataAccessException̏ꍇ͂̂܂܃X[܂B
			throw e;
		} catch (Exception e) {
			// ̑G[ꍇAAccessorUnknownExceptionX[
			Object[] msg = {
					sql,
					""
				};
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_DBACCESS_011,
					LogMessageConstant.CB3_ACCESSOR_DBACCESS_009, msg), e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public int delete(String key, DBQueryParameterMap parameter)
		throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {

		// SQL擾
		String sql = deleteSqlCache.get(key);
		// SQLNULLꍇ
		if (sql == null || "".equals(sql)) {
			// DataFileNoSuchSqlIdException쐬
			DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_012,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_011, key, "delete"));
			//Oo
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}

		try {
			// p[^tꍇ
			int rtCnt = getCB3JdbcTemplate().update(sql, parameter);
			// R~bg
			divideCommit(key,rtCnt);
			// ʂ߂
			return	rtCnt;

		} catch (DataAccessException e) {
			// DataAccessException̏ꍇ͂̂܂܃X[܂B
			throw e;

		} catch (Exception e) {
			// ̑G[ꍇAAccessorUnknownExceptionX[
			Object[] msg = {
					sql,
					parameter
				};
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_DBACCESS_013,
					LogMessageConstant.CB3_ACCESSOR_DBACCESS_010, msg), e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public int delete(String key)
		throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {

		// SQL擾
		String sql = deleteSqlCache.get(key);
		// SQLNULLꍇ
		if (sql == null || "".equals(sql)) {
			// DataFileNoSuchSqlIdException쐬
			DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_014,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_011, key, "delete"));
			//Oo
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}

		try {
			// p[^tȂꍇ
			int rtCnt = getCB3JdbcTemplate().update(sql);
			// R~bg
			divideCommit(key,rtCnt);

			// ʂ߂
			return	rtCnt;

		} catch (DataAccessException e) {
			// DataAccessException̏ꍇ͂̂܂܃X[܂B
			throw e;

		} catch (Exception e) {
			// ̑G[ꍇAAccessorUnknownExceptionX[
			Object[] msg = {
					sql,
					""
				};
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_DBACCESS_015,
					LogMessageConstant.CB3_ACCESSOR_DBACCESS_010, msg), e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public int insert(String key, DBQueryParameterMap parameter)
		throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {

		// SQL擾
		String sql = insertSqlCache.get(key);
		// SQLNULLꍇ
		if (sql == null || "".equals(sql)) {
			// DataFileNoSuchSqlIdException쐬
			DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_016,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_011, key, "insert"));
			//Oo
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}

		try {
			// p[^tꍇ
			int rtCnt = getCB3JdbcTemplate().update(sql, parameter);
			// R~bg
			divideCommit(key,rtCnt);

			// ʂ߂
			return	rtCnt;

		} catch (DataAccessException e) {
			// DataAccessException̏ꍇ͂̂܂܃X[܂B
			throw e;

		} catch (Exception e) {
			// ̑G[ꍇAAccessorUnknownExceptionX[
			Object[] msg = {
					sql,
					parameter
				};
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_DBACCESS_017,
					LogMessageConstant.CB3_ACCESSOR_DBACCESS_008, msg), e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	public int insert(String key)
		throws DataFileNoSuchSqlIdException, DataAccessException, AccessorUnknownException {

		// SQL擾
		String sql = insertSqlCache.get(key);
		// SQLNULLꍇ
		if (sql == null || "".equals(sql)) {
			// DataFileNoSuchSqlIdException쐬
			DataFileNoSuchSqlIdException ex = new DataFileNoSuchSqlIdException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_018,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_011, key, "insert"));
			//Oo
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}

		try {
			// p[^tȂꍇ
			int rtCnt = getCB3JdbcTemplate().update(sql);
			divideCommit(key,rtCnt);

			// ʂ߂
			return rtCnt;

		} catch (DataAccessException e) {
			// DataAccessException̏ꍇ͂̂܂܃X[܂B
			throw e;

		} catch (Exception e) {
			// ̑G[ꍇAAccessorUnknownExceptionX[
			Object[] msg = {
					sql,
					""
				};
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_DBACCESS_019,
					LogMessageConstant.CB3_ACCESSOR_DBACCESS_008, msg), e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	/**
	 *
	 * w肳ꂽSQLɕR~bg̎w肪Aw茏ɒBꍇ̓R~bgsB
	 *
	 * @param key SQLID
	 * @param count R~bgs
	 */
	private void divideCommit(String key, int count) {

		// R~bgP
		String cmtLimitCnt = commitLimitCountMap.get(key);
		// JEg
		Integer cmtCount = commitCountMap.get(key);

		if (cmtCount == null) {
			cmtCount = 0;
		}

		// R~bgPʂw肢ꍇ
		if (cmtLimitCnt != null && !"".equals(cmtLimitCnt)){
			// JEg
			cmtCount += count;
			// R~bgPʌ𒴂ꍇ
			if(cmtCount >= Integer.parseInt(cmtLimitCnt)){
				// R~bg
				getCB3JdbcTemplate().commit();
				// JEgNA
				cmtCount = 0;
			}
			commitCountMap.put(key, cmtCount);
		}
	}
}

