/*
 * DBRecord.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;

/**
 * DBR[h\C^tF[XNXB
 * @author Lijuan Sun
 */
public interface DBRecord {

	/**
	 * ukeyvɊYlString^ŕԋp܂B
	 * @param key L[
	 * @return String
	 */
	String  getString(String key);

	/**
	 * ukeyvɊYlInteger^ŕԋp܂B
	 * @param key L[
	 * @return Integer
	 */
	Integer getInteger(String key);

	/**
	 * ukeyvɊYlObject^ŕԋp܂B
	 * @param key L[
	 * @return Object
	 */
	Object getObject(String key);

	/**
	 * ukeyvɊYlBigDecimal^ŕԋp܂B
	 * @param key L[
	 * @return BigDecimal
	 */
	BigDecimal getBigDecimal(String key);

	/**
	 * ukeyvɊYlLong^ŕԋp܂B
	 * @param key L[
	 * @return Long
	 */
	Long getLong(String key);

	/**
	 * ukeyvɊYlFloat^ŕԋp܂B
	 * @param key L[
	 * @return Float
	 */
	Float getFloat(String key);

	/**
	 * ukeyvɊYlShort^ŕԋp܂B
	 * @param key L[
	 * @return Short
	 */
	Short getShort(String key);

	/**
	 * ukeyvɊYlDate^ŕԋp܂B
	 * @param key L[
	 * @return Date
	 */
	Date getDate(String key);

	/**
	 * ukeyvɊYlTimestamp^ŕԋp܂B
	 * @param key L[
	 * @return Timestamp
	 */
	Timestamp getTimestamp(String key);

	/**
	 * PR[hMapԂB
	 * @return PR[hMap
	 */
	Map<String, Object> toMap();

	/**
	 * PR[hMapԂB
	 * @return PR[hMap
	 */
	Map<String, String> toMapStringValue();

}
