/*
 * JdbcRecord.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import jp.co.cybec.cb3.util.DateUtil;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

/**
 * R[h\C^tF[X̎NXB
 * @author Lijuan Sun
 */
public class JdbcRecord implements DBRecord {

	/** O */
	private static final Log LOG = LogFactory.getLog(JdbcRecord.class);

	/** YR[hwResultSet */
	private ResultSet resultSet = null;

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** SQL */
	private String sql = null;

	/** SQL̃p[^ */
	private DBQueryParameterMap parameter = null;

	/** sԍ */
	private int row = 0;

	/** R[hMap */
	HashMap<String, Object> recordMap = null;

	/** String^̒lێ郌R[hMap */
	HashMap<String, String> recordStringMap = null;

	/**
	 *
	 * RXgN^
	 *
	 * @param rs YR[hwResultSet
	 * @param sql ResultSet擾ɎgpSQL
	 * @param parameter sql̃p[^
	 * @param row sԍ
	 */
	public JdbcRecord(ResultSet rs, String sql, DBQueryParameterMap parameter, int row){

		this.resultSet = rs;
		this.sql = sql;
		this.parameter = parameter;
		this.row = row;
	};

	 /**
	 * ucolumnNamevɊYlInteger^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return Integer
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Integer getInteger(String columnName) throws DataAccessException {
		try {
			return new Integer(resultSet.getInt(columnName));
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_021,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"Integer",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	 /**
	 * ucolumnNamevɊYlObject^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return Object
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Object getObject(String columnName) throws DataAccessException {
		try {
			return resultSet.getObject(columnName);
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_022,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"Object",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	 /**
	 * ucolumnNamevɊYlString^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return String
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public String getString(String columnName) throws DataAccessException {
		try {
			return resultSet.getString(columnName);
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_023,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"String",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	 /**
	 * ucolumnNamevɊYlBigDecimal^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return BigDecimal
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public BigDecimal getBigDecimal(String columnName) throws DataAccessException {
		try {
			return resultSet.getBigDecimal(columnName);
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_024,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"BigDecimal",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	 /**
	 * ucolumnNamevɊYlDate^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return Date
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Date getDate(String columnName) throws DataAccessException {
		try {
			return new Date(resultSet.getDate(columnName).getTime());
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_025,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"Date",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	 /**
	 * ucolumnNamevɊYlFloat^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return Float
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Float getFloat(String columnName) throws DataAccessException {
		try {
			return new Float(resultSet.getFloat(columnName));
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_026,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"Float",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	 /**
	 * ucolumnNamevɊYlLong^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return Long
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Long getLong(String columnName) throws DataAccessException {
		try {
			return new Long(resultSet.getLong(columnName));
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_027,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"Long",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	 /**
	 * ucolumnNamevɊYlShort^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return Short
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Short getShort(String columnName) throws DataAccessException {
		try {
			return new Short(resultSet.getShort(columnName));
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_028,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"Short",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	 /**
	 * ucolumnNamevɊYlTimestamp^ŕԋp܂B
	 *
	 * @param columnName ږ
	 * @return Timestamp
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Timestamp getTimestamp(String columnName) throws DataAccessException {
		try {
			return resultSet.getTimestamp(columnName);
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_029,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_006,
							"Timestamp",
							sql,
							stringOfParameter,
							stringOfRowIndex,
							columnName),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
	}

	/**
	 * PR[hMapԂB
	 *
	 * @return PR[hMap
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Map<String, Object> toMap() throws DataAccessException {

		if (recordMap != null) {
			return recordMap;
		}

		recordMap = new HashMap<String, Object>();

		int columns = 0;
		try {
			columns = resultSet.getMetaData().getColumnCount();

			for (int index = 1; index <= columns; index++) {

				int type = resultSet.getMetaData().getColumnType(index);

				Object value = null;
				switch (type) {
				case java.sql.Types.DATE:
					Date date = resultSet.getDate(index);
					if (date != null) {
						value = new Date(date.getTime());
					}
					break;
				case java.sql.Types.TIMESTAMP:
					value = resultSet.getTimestamp(index);
					break;
				default:
					value = resultSet.getObject(index);
				}

				recordMap.put(resultSet.getMetaData().getColumnName(index), value);
			}
		} catch (SQLException e) {
			// DataAccessExceptionX[
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			String stringOfRowIndex = (row == 0 ? "" : Integer.toString(row));
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(
					MESSAGE.getErrorMessage(
							ErrorCodeConstant.ACCESSOR_DBACCESS_020,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_005,
							sql,
							stringOfParameter,
							stringOfRowIndex),
					"",
					e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
		return recordMap;
	}

	/**
	 * PR[hMapԂB
	 *
	 * @return PR[hMap
	 * @throws DataAccessException f[^쎞ɃG[ꍇB
	 */
	public Map<String, String> toMapStringValue() throws DataAccessException {

		if (recordStringMap != null) {
			return recordStringMap;
		}

		recordStringMap = new HashMap<String, String>();
		for (Map.Entry<String, Object> entry : toMap().entrySet()) {
			String value = null;
			Object obj = entry.getValue();
			if (obj != null) {
				if (obj instanceof Timestamp) {
					value = DateUtil.formatTimestamp((Timestamp) obj);
				} else if (obj instanceof Date) {
					value = DateUtil.formatDate((Date) obj);
				} else {
					value = obj.toString();
				}
			}
			recordStringMap.put(entry.getKey(), value);
		}

		return recordStringMap;
	}
}
