/*
 * JdbcRecordReader.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.dbaccess;

import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.support.SQLStateSQLExceptionTranslator;

/**
 * f[^x[X̃f[^PR[hǂݍރNXłB<br>
 *
 * @author Lijuan Sun
 */
public class JdbcRecordReader implements DBRecordReader{

	/** O */
	private static final Log LOG = LogFactory.getLog(JdbcRecordReader.class);

	/** f[^ǂݍ݌ResultSet */
	private ResultSet resultSet = null;

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** SQL */
	private String sql = null;

	/** SQL̃p[^ */
	private DBQueryParameterMap parameter = null;

	/** ̍sԍ */
	private int row = 0;

	/**
	 * RXgN^
	 *
	 * @param rs f[^ǂݍ݌ResultSet
	 * @param sql ResultSet擾ɎgpSQL
	 * @param parameter ResultSet擾ɎgpSQL̈
	 */
	public JdbcRecordReader(ResultSet rs, String sql, DBQueryParameterMap parameter){

		this.resultSet = rs;
		this.sql = sql;
		this.parameter = parameter;
	};

	/**
	 * RXgN^
	 *
	 * @param rs f[^ǂݍ݌ResultSet
	 * @param sql ResultSet擾ɎgpSQL
	 */
	public JdbcRecordReader(ResultSet rs, String sql){

		this(rs, sql, null);
	};

	/**
	 * ̃R[hԋp܂
	 * @return ̃R[hB݂Ȃꍇ́AnullԂB
	 * @throws DataAccessException 炩̃f[^x[XANZXG[ꍇB
	 */
	public DBRecord nextRecord() throws DataAccessException {

		JdbcRecord record = null;
		// sԍCNgB
		row++;

		try {
			if (resultSet.next()) {
				// ̃f[^ꍇ
				record = new JdbcRecord(resultSet, sql, parameter, row);

				// fobOO
				if (LOG.isDebugEnabled()) {
					LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_DBACCESS_015, row, record.toMap()));
				}
			}
			else {
				// ̃f[^Ȃꍇ
				record = null;
			}
		} catch (SQLException e) {
			// DataAccessExceptionX[;
			String stringOfParameter = (parameter == null ? "" : parameter.toString());
			DataAccessException ex = new SQLStateSQLExceptionTranslator().translate(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_DBACCESS_030,
							LogMessageConstant.CB3_ACCESSOR_DBACCESS_004, sql, stringOfParameter,
							row), "", e);
			// infoŃOo͂
			LOG.info(ex.getMessage(), ex);
			// X[
			throw ex;
		}
		// ʂ߂
		return record;
	}
}
