/*
 * RecordFieldReaderFormat.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess;

import java.math.BigDecimal;
import java.util.Date;

import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.DateUtil;
import jp.co.cybec.cb3.util.NumberUtil;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * t@C̃R[hڂtH[}bgNX(Readerp)B
 * @author  Jianming Guo
 */
public class RecordFieldReaderFormat implements RecordFieldReaderFormatable {
	/** O */
	private static final Log LOG = LogFactory.getLog(RecordFieldReaderFormat.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** ݒt@CpX */
	private String filepath = null;

	/** ږ */
	private String field = null;

	/**
	 * RXgN^
	 *
	 * @param filepath ݒt@CpX
	 * @param field ږ
	 */
	public RecordFieldReaderFormat(String filepath, String field){
		this.filepath = filepath;
		this.field = field;
	}

	/**
	 * ̕tH[}bg܂B
	 *
	 * @param pattern tH[}bg
	 * @param type ^Cv
	 * @param data tH[}bgΏۂ̕
	 * @return tH[}bg̕
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public String format(String pattern, String type, String data) throws DataFormatException {
		String retValue = null;

		// ̕NULL or 󔒂̏ꍇ
		if (data == null || data.trim().length() == 0) {
			return data;
		}

		// p^[w̏ꍇ
		if (pattern == null || pattern.length() == 0) {
			return data;
		}

		// ^Cvw or ^CvȂꍇ
		if (type == null || (!type.equalsIgnoreCase(RecordFieldConstants.TYPE_NUMBER)
				&& !type.equalsIgnoreCase(RecordFieldConstants.TYPE_DATE))) {
			DataFormatException ex = new DataFormatException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_FILEACCESS_001,
							LogMessageConstant.CB3_ACCESSOR_FILEACCESS_008, this.filepath,
							this.field, type));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		try {
			if (type.equalsIgnoreCase(RecordFieldConstants.TYPE_NUMBER)) {
			// ^CvF̏ꍇ
				// BigDecimalɕϊ
				BigDecimal bNum = NumberUtil.parseBigDecimal(pattern, data);

				// BigDecimal̕ɕϊ
				retValue = NumberUtil.numberToString(bNum, NumberUtil.getFractionDigits(pattern));

			} else {
			// ^CvFt̏ꍇ
				// Dateɕϊ
				Date date = DateUtil.parseDate(data, pattern);
				// DateftHgtH[}bg̕ɕϊ
				retValue = DateUtil.formatDate(date);
			}
		} catch (Exception e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_002,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_007, this.field, data, pattern));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		return retValue;
	}

	/**
	 * ̕g܂B
	 * (pfBO菜܂)
	 *
	 * @param algin   ACgwq(E񂹁E)
	 * @param padding pfBO
	 * @param data gΏۂ̕
	 * @return pfBO菜
	 * @throws DataFormatException ACgwqApfBO̎wɊԈႢꍇɔ܂B
	 */
	public String trim(String algin, String padding, String data) throws DataFormatException {
		String retValue = null;

		if(data == null){
			return null;
		}

		// ǂ炩ݒ̏ꍇ
		if ((algin == null || algin.trim().length() == 0) ||
				(padding == null || padding.length() == 0)) {
			return data;
		}

		// ACg̃`FbN
		if (!algin.equalsIgnoreCase(RecordFieldConstants.ALGIN_LEFT)
				&& !algin.equalsIgnoreCase(RecordFieldConstants.ALGIN_RIGHT)) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_003,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_011, this.filepath, this.field,
					algin));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// pfBÕoCg`FbN
		if (padding.getBytes().length > 1) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_004,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_012, this.filepath, this.field,
					padding));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		char paddingChar = padding.charAt(0);
		if (algin.equalsIgnoreCase(RecordFieldConstants.ALGIN_LEFT)) {
		// 񂹂̏ꍇ
			int index = data.length();
			for (int i = data.length() -1 ; i >= 0; i--) {
				if (data.charAt(i) != paddingChar) {
					break;
				}
				index = i;
			}
			retValue = data.substring(0, index);
		} else {
		// E񂹂̏ꍇ
			int index = -1;
			for (int i = 0 ; i <= data.length() - 1; i++) {
				if (data.charAt(i) != paddingChar) {
					break;
				}
				index = i;
			}
			retValue = data.substring(index + 1);
		}

		return retValue;
	}
}
