/*
 * RecordFieldWriterFormat.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess;

import java.util.Arrays;
import java.util.Date;

import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.DateUtil;
import jp.co.cybec.cb3.util.NumberUtil;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

 /**
  * t@C̃R[hڂtH[}bgNX(Writerp)B
  * @author Jianming Guo
  */
public class RecordFieldWriterFormat implements RecordFieldWriterFormatable {
	/** O */
	private static final Log LOG = LogFactory.getLog(RecordFieldWriterFormat.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** ݒt@CpX */
	private String filepath = null;

	/** ږ */
	private String field = null;

	/**
	 * RXgN^
	 *
	 * @param filepath ݒt@CpX
	 * @param field ږ
	 */
	public RecordFieldWriterFormat(String filepath, String field){
		this.filepath = filepath;
		this.field = field;
	}

	/**
	 * ̕tH[}bg܂B
	 *
	 * @param pattern tH[}bg
	 * @param type ^Cv
	 * @param data tH[}bgΏۂ̕
	 * @return tH[}bg̕
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public String format(String pattern, String type, String data) throws DataFormatException {
		String retValue = null;

		// ̕NULL or 󔒂̏ꍇ
		if (data == null || data.trim().length() == 0) {
			return data;
		}

		// p^[w̏ꍇ
		if (pattern == null || pattern.length() == 0) {
			return data;
		}

		// ^Cvw or ^CvȂꍇ
		if (type == null || (!type.equalsIgnoreCase(RecordFieldConstants.TYPE_NUMBER)
				&& !type.equalsIgnoreCase(RecordFieldConstants.TYPE_DATE))) {
			String messageId = LogMessageConstant.CB3_ACCESSOR_FILEACCESS_008;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_005, messageId, this.filepath,
					this.field, type));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		try {
			if (type.equalsIgnoreCase(RecordFieldConstants.TYPE_NUMBER)) {
			// ^CvF̏ꍇ
				retValue = NumberUtil.formatNumber(pattern, data);

			} else {
			// ^CvFt̏ꍇ
				// (ftH[gtH[}bg)Dateɕϊ
				Date date = DateUtil.parseDate(data);
				// Dateɕϊ
				retValue = DateUtil.formatDate(date, pattern);
			}
		} catch (Exception e) {
			String messageId = LogMessageConstant.CB3_ACCESSOR_FILEACCESS_007;
			DataFormatException ex = new DataFormatException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_FILEACCESS_006, messageId,
							this.field, data, pattern));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		return retValue;

	}

	/**
	 * ̕pfBO܂B
	 *
	 * @param length  oCg
	 * @param algin   ACgwq(E񂹁E)
	 * @param padding pfBO
	 * @param data pfBOΏۂ̕
	 * @return pfBO̕
	 * @throws DataFormatException Ɏw肳ꂽl̃tH[}bgɊԈႢꍇɔ܂B
	 */
	public String padding(String length, String algin, String padding, String data) throws DataFormatException {
		int iLength;

		if(data == null){
			data = new String();
		}

		// ǂ炩ݒ̏ꍇ
		if ((length == null || length.trim().length() == 0) ||
				(algin == null || algin.trim().length() == 0) ||
				(padding == null || padding.length() == 0)) {
			return data;
		}

		// ACgwq(E񂹁E)̃`FbN
		if (!algin.equalsIgnoreCase(RecordFieldConstants.ALGIN_LEFT)
				&& !algin.equalsIgnoreCase(RecordFieldConstants.ALGIN_RIGHT)) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_007,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_011, this.filepath, this.field,
					algin));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// pfBÕoCg`FbN
		if (padding.getBytes().length > 1) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_008,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_012, this.filepath, this.field,
					padding));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		try {
			iLength = Integer.parseInt(length);
		} catch (NumberFormatException e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_009,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_012, this.filepath, this.field,
					length));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// f[^̃oCg`FbN
		if (data.getBytes().length > iLength) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_010,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_014, data, this.filepath,
					this.field, length));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// ̕  charz
		char[] dataCharArr = data.toCharArray();
		// ̕ɑSpƔp̍݉\邽߁ARs[pcharz쐬
		int retCharLength = iLength - (data.getBytes().length - dataCharArr.length);
		char[] retCharArr = new char[retCharLength];
		Arrays.fill(retCharArr, padding.charAt(0));

		if (algin.equalsIgnoreCase(RecordFieldConstants.ALGIN_LEFT)) {
		// 񂹂̏ꍇ
			System.arraycopy(dataCharArr, 0, retCharArr, 0, dataCharArr.length);
		} else {
		// E񂹂̏ꍇ
			System.arraycopy(dataCharArr, 0, retCharArr, retCharArr.length - dataCharArr.length, dataCharArr.length);
		}

		return String.valueOf(retCharArr);
	}

}
