/*
 * FlatFileRecord.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

import jp.co.cybec.cb3.exception.DataFormatException;

/**
 * t@C̃R[h\C^tF[XB
 * @author Jianming Guo
 */
public interface FlatFileRecord {

	/**
	 * <code>key</code>ɊYlString^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return ڒl
	 */
	String getString(String key);

	/**
	 * <code>key</code>ɊYlBigDecimal^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return ڒl
	 * @throws DataFormatException f[^^̕ϊɎsꍇɔ܂B
	 */
	BigDecimal getBigDecimal(String key) throws DataFormatException;

	/**
	 * <code>key</code>ɊYlDouble^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return ڒl
	 * @throws DataFormatException f[^^̕ϊɎsꍇɔ܂B
	 */
	Double getDouble(String key) throws DataFormatException;

	/**
	 * <code>key</code>ɊYlInteger^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return ڒl
	 * @throws DataFormatException f[^^̕ϊɎsꍇɔ܂B
	 */
	Integer getInteger(String key) throws DataFormatException;

	/**
	 * <code>key</code>ɊYlLong^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return ڒl
	 * @throws DataFormatException f[^^̕ϊɎsꍇɔ܂B
	 */
	Long getLong(String key) throws DataFormatException;

	/**
	 * <code>key</code>ɊYlFloat^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return ڒl
	 * @throws DataFormatException f[^^̕ϊɎsꍇɔ܂B
	 */
	Float getFloat(String key) throws DataFormatException;

	/**
	 * <code>key</code>ɊYlShort^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return ڒl
	 * @throws DataFormatException f[^^̕ϊɎsꍇɔ܂B
	 */
	Short getShort(String key) throws DataFormatException;

	/**
	 * <code>key</code>ɊYlDate^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return ڒl
	 * @throws DataFormatException f[^^̕ϊɎsꍇɔ܂B
	 */
	Date getDate(String key) throws DataFormatException;

	/**
	 * R[h̓e<code>Map</code>ŕԋp܂B
	 *
	 * @return R[h
	 */
	Map<String, String> toMap();

}
