/*
 * FlatFileRecordImpl.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.DateUtil;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * t@C̃R[h̎NXB
 * @author Jianming Guo
 */
public class FlatFileRecordImpl implements FlatFileRecord {

	/** O */
	private static final Log LOG = LogFactory.getLog(FlatFileRecordImpl.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** R[h}bv */
	private LinkedHashMap<String, String> fileRecordMap = null;

	/**
	 * RXgN^
	 *
	 * @param recordMap R[h}bv
	 */
	public FlatFileRecordImpl(LinkedHashMap<String, String> recordMap){
		fileRecordMap = new LinkedHashMap<String, String>();
		this.fileRecordMap.putAll(recordMap);
	}

	/**
	 * ukeyvɊYlString^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return String
	 */
	public String getString(String key){
		return this.fileRecordMap.get(key);
	}

	/**
	 * ukeyvɊYlBigDecimal^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return BigDecimal^
	 * @throws DataFormatException f[^^ϊG[ꍇɔ܂B
	 */
	public BigDecimal getBigDecimal(String key) throws DataFormatException {
		String value = null;
		try {
			value =  this.fileRecordMap.get(key);
			if (value == null || value.length() == 0) {
				return null;
			} else {
				return new BigDecimal(value);
			}
		} catch (NumberFormatException e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_001,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005, key, value));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ukeyvɊYlDouble^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return Double^
	 * @throws DataFormatException f[^^ϊG[ꍇɔ܂B
	 */
	public Double getDouble(String key) throws DataFormatException {
		String value = null;
		try {
			value =  this.fileRecordMap.get(key);
			if (value == null || value.length() == 0) {
				return null;
			} else {
				return Double.valueOf(value);
			}
		} catch (NumberFormatException e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_002,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005, key, value));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ukeyvɊYlInteger^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return Integer^
	 * @throws DataFormatException f[^^ϊG[ꍇɔ܂B
	 */
	public Integer getInteger(String key) throws DataFormatException {
		String value = null;
		try {
			value =  this.fileRecordMap.get(key);
			if (value == null || value.length() == 0) {
				return null;
			} else {
				return Integer.valueOf(value);
			}
		} catch (NumberFormatException e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_003,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005, key, value));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ukeyvɊYlLong^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return Long^
	 * @throws DataFormatException f[^^ϊG[ꍇɔ܂B
	 */
	public Long getLong(String key) throws DataFormatException {
		String value = null;
		try {
			value =  this.fileRecordMap.get(key);
			if (value == null || value.length() == 0) {
				return null;
			} else {
				return Long.valueOf(value);
			}
		} catch (NumberFormatException e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_004,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005, key, value));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ukeyvɊYlFloat^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return Float^
	 * @throws DataFormatException f[^^ϊG[ꍇɔ܂B
	 */
	public Float getFloat(String key) throws DataFormatException {
		String value = null;
		try {
			value =  this.fileRecordMap.get(key);
			if (value == null || value.length() == 0) {
				return null;
			} else {
				return Float.valueOf(value);
			}
		} catch (NumberFormatException e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_005,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005, key, value));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ukeyvɊYlShort^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return Short^
	 * @throws DataFormatException f[^^ϊG[ꍇɔ܂B
	 */
	public Short getShort(String key) throws DataFormatException {
		String value = null;
		try {
			value =  this.fileRecordMap.get(key);
			if (value == null || value.length() == 0) {
				return null;
			} else {
				return Short.valueOf(value);
			}
		} catch (NumberFormatException e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_006,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005, key, value));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ukeyvɊYlDate^ŕԋp܂B
	 *
	 * @param key ږ
	 * @return Date^t
	 * @throws DataFormatException f[^^ϊG[ꍇɔ܂B
	 */
	public Date getDate(String key) throws DataFormatException {
		String value = null;
		try {
			value =  this.fileRecordMap.get(key);
			if (value == null || value.length() == 0) {
				return null;
			} else {
				return DateUtil.parseDate(value);
			}
		} catch (ParseException e) {
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_007,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005, key, value));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * R[h}bvԋp܂B
	 *
	 * @return R[h}bv
	 */
	public Map<String, String> toMap() {
		return this.fileRecordMap;
	}
}
