/*
 * FlatFileRecordReader.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;

/**
 * t@C̃R[hǂݍނ߂̃C^tF[XB
 * @author Jianming Guo
 */
public interface FlatFileRecordReader extends Accessor {

	/**
	 * t@CI[v܂B
	 *
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException ;

	/**
	 * t@CI[v܂B
	 *
	 * @param filepath f[^t@C̃pX
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 */
	void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException ;

	/**
	 * ̃R[hԋp܂
	 *
	 * @return ̃R[h
	 * @throws AccessorNotOpenException t@CI[vĂȂꍇɔ܂B
	 * @throws DataFileIOException  R[h̓ǂݍݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	FlatFileRecord nextRecord() throws AccessorNotOpenException, DataFileIOException, DataFormatException ;

	/**
	 * t@CN[Y܂B
	 *
	 * @throws DataFileIOException t@CN[YIOG[ɂ蔭܂B
	 */
	void close() throws DataFileIOException;

}
