/*
 * FlatFileRecordWriterImpl.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.flat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;

import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.accessor.fileaccess.RecordFieldConstants;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * t@C̃R[h݃NXB
 * @author Jianming Guo
 */
public class FlatFileRecordWriterImpl implements FlatFileRecordWriter, AccessorsLifeCycle {
	/** O */
	private static final Log LOG = LogFactory.getLog(FlatFileRecordWriterImpl.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/** t@CpX */
	private String filepath = null;

	/** obt@[C^[ */
	private BufferedWriter writer = null;

	/** GR[h */
	private String encode = null;

	/** t@CI[v[h */
	private boolean append = false;

	/** t@C̃I[vԂێtO */
	private boolean isOpen = false;

	/**
	 * t@CI[v܂B
	 *
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃꍇɔ܂B
	 * @throws DataFileIOException IOG[̏ꍇɔ܂B
	 */
	public void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException, DataFileIOException {
		// łopenĂꍇAOX[܂B
		if (isOpen) {
			AccessorAlreadyOpenedException ex = new AccessorAlreadyOpenedException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_012,
							LogMessageConstant.CB3_ACCESSOR_FILEACCESS_002, filepath));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// t@CpXݒ肳ĂȂꍇ͗OX[܂B
		if (filepath == null || filepath.length() == 0) {
			DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_017,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_018));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		try {
			// obt@[C^[쐬
			writer = new BufferedWriter(new OutputStreamWriter(
					new FileOutputStream(new File(filepath), append), encode));
			isOpen = true;
		} catch (FileNotFoundException e) {
			DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_013,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_003, e));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		} catch (IOException e) {
			DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_014,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004, e));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * t@CI[v܂B
	 *
	 * @param filepath f[^t@C̃pX
	 * @throws AccessorAlreadyOpenedException t@CłɃI[vĂꍇɔ܂B
	 * @throws DataFileNotFoundException t@C݂Ȃꍇɔ܂B
	 * @throws DataFileIOException IOG[̏ꍇɔ܂B
	 */
	public void open(String filepath) throws AccessorAlreadyOpenedException,
			DataFileNotFoundException, DataFileIOException {
		this.filepath = filepath;
		open();
	}

	/**
	 * t@CɂPs̃R[h݂܂B
	 *
	 * @param record 1s̃R[h
	 * @throws AccessorNotOpenException t@CI[vĂȂꍇɔ܂B
	 * @throws DataFileIOException R[h̏ݎIOG[ɂ蔭܂B
	 * @throws DataFormatException R[hڂ̃tH[}bgɎsꍇɔ܂B
	 */
	public void write(FlatFileRecord record) throws AccessorNotOpenException, DataFileIOException, DataFormatException {
		// qNXŎ
	}

	/**
	 * FlatFileRecordf[^쐬܂B
	 *
	 * @param record f[^}bv
	 * @return 쐬FlatFileRecordf[^
	 */
	public FlatFileRecord createFlatFileRecord(Map<String, String> record) {
		// qNXŎ

		return null;
	}

	/**
	 * t@CN[Y܂B
	 *
	 * @throws DataFileIOException t@C̃N[YɎsꍇɔ܂B
	 */
	public void close() throws DataFileIOException {
		if (isOpen) {
			try {
				writer.close();
				writer = null;
				isOpen = false;
			} catch (IOException e) {
				DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_FILEACCESS_FLAT_015,
						LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004, e));
				LOG.info(ex.getMessage(), ex);
				throw ex;
			}
		}
	}

	/**
	 * ݒt@CǂݍށB
	 *
	 * @param key ݒt@C
	 */
	public void initialize(String key) {
		// qNXŎ
	}

	/**
	 * ㏈B
	 */
	public void release() {
		close();
	}

	/**
	 * t@CpXԂ܂B
	 *
	 * @return t@CpX
	 */
	protected String getFilepath() {
		return filepath;
	}

	/**
	 * t@CpXݒ肵܂B
	 *
	 * @param filepath t@CpX
	 */
	protected void setFilepath(String filepath) {
		this.filepath = filepath;
	}

	/**
	 * obt@[C^[Ԃ܂B
	 *
	 * @return obt@[C^[
	 */
	protected BufferedWriter getBufferedWriter() {
		return writer;
	}

	/**
	 * t@C̃I[vԂԂ܂B
	 *
	 * @return t@C̃I[v
	 */
	protected boolean isOpen() {
		return this.isOpen;
	}

	/**
	 * t@CI[v[hԂ܂B
	 *
	 * @return t@CI[v[h
	 */
	protected boolean getAppend() {
		return append;
	}

	/**
	 * t@CI[v[hݒ肵܂B
	 *
	 * @param append t@CI[v[h
	 */
	protected void setAppend(String append) {
		if (append.equalsIgnoreCase(RecordFieldConstants.FILE_OPEN_APPEND_TRUE)) {
			this.append = true;
		} else {
			this.append = false;
		}
	}

	/**
	 * GR[hԂ܂B
	 *
	 * @return GR[h
	 */
	protected String getEncode() {
		return encode;
	}

	/**
	 * GR[hݒ肵܂B
	 *
	 * @param encode GR[h
	 */
	protected void setEncode(String encode) {
		this.encode = encode;
	}
}
