/*
 * XMLElement.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

import jp.co.cybec.cb3.exception.DataFormatException;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * XMLt@C̍ڂ\NXB
 * @author Daisuke Suga
 */
public class XMLElement {

	/** O */
	private static final Log LOG = LogFactory.getLog(XMLElement.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * ڂ̖OB
	 */
	private String name = null;

	/**
	 * ڂ̒lB
	 */
	private String value = null;

	/**
	 * ڂ̖OԂURIB
	 */
	private String uri = "";

	/**
	 * ڂQNameB
	 */
	private String qName = "";

	/**
	 * ڂ̑B
	 */
	private XMLAttributes attributes = new XMLAttributes();

	/**
	 * ANZbT̃L[B
	 */
	private String key = null;

	/**
	 * pXB
	 */
	private String path = null;

	/**
	 * RXgN^B
	 *
	 * @param name ڂ̖O
	 */
	public XMLElement(String name) {
		this(name, null, null);
	}

	/**
	 * RXgN^B<br>
	 * {@link XMLFileReader#selectPath(String)}ŌʂێꍇɎgp܂B
	 *
	 * @param name ڂ̖O
	 * @param key ANZbT̃L[
	 * @param path pX
	 */
	protected XMLElement(String name, String key, String path) {
		this.name = name;
		this.key = key;
		this.path = path;
	}

	/**
	 * ڂ̖O擾܂B
	 * @return ڂ̖O
	 */
	public String getName() {
		return name;
	}

	/**
	 * ڂ̒lStringŎ擾܂B
	 * @return ڂ̒l
	 */
	public String getString() {
		return value;
	}

	/**
	 * ڂ̒lStringŐݒ肵܂B
	 * @param value ڂ̒l
	 */
	public void setString(String value) {
		this.value = value;
	}

	/**
	 * ڂ̒lIntegerŎ擾܂B
	 *
	 * @return ڂ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Integer getInteger() throws DataFormatException {
		try {
			return value != null ? Integer.valueOf(value) : null;
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_003;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_007, messageId, name, value, key,
					path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ڂ̒lIntegerŐݒ肵܂B
	 * @param value ڂ̒l
	 */
	public void setInteger(Integer value) {
		this.value = value != null ? value.toString() : null;
	}

	/**
	 * ڂ̒lLongŎ擾܂B
	 *
	 * @return ڂ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Long getLong() throws DataFormatException {
		try {
			return value != null ? Long.valueOf(value) : null;
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_003;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_008, messageId, name, value, key,
					path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ڂ̒lLongŐݒ肵܂B
	 * @param value ڂ̒l
	 */
	public void setLong(Long value) {
		this.value = value != null ? value.toString() : null;
	}

	/**
	 * ڂ̒lFloatŎ擾܂B
	 *
	 * @return ڂ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Float getFloat() throws DataFormatException {
		try {
			return value != null ? Float.valueOf(value) : null;
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_003;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_009, messageId, name, value, key,
					path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ڂ̒lFloatŐݒ肵܂B
	 * @param value ڂ̒l
	 */
	public void setFloat(Float value) {
		this.value = value != null ? value.toString() : null;
	}

	/**
	 * ڂ̒lShortŎ擾܂B
	 *
	 * @return ڂ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Short getShort() throws DataFormatException {
		try {
			return value != null ? Short.valueOf(value) : null;
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_003;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_010, messageId, name, value, key,
					path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ڂ̒lShortŐݒ肵܂B
	 * @param value ڂ̒l
	 */
	public void setShort(Short value) {
		this.value = value != null ? value.toString() : null;
	}

	/**
	 * ڂ̒lBigDecimalŎ擾܂B
	 *
	 * @return ڂ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public BigDecimal getBigDecimal() throws DataFormatException {
		try {
			return value != null ? new BigDecimal(value) : null;
		} catch (NumberFormatException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_003;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_011, messageId, name, value, key,
					path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ڂ̒lBigDecimalŐݒ肵܂B
	 * @param value ڂ̒l
	 */
	public void setBigDecimal(BigDecimal value) {
		this.value = value != null ? value.toString() : null;
	}

	/**
	 * ڂ̒lDateŎ擾܂B
	 *
	 * @return ڂ̒l
	 * @throws DataFormatException f[^^̕ϊɎsƂɔ܂B
	 */
	public Date getDate() throws DataFormatException {
		try {
			return value != null ? DateFormat.getDateInstance().parse(value) : null;
		} catch (ParseException e) {
			String messageId = key == null ? LogMessageConstant.CB3_ACCESSOR_FILEACCESS_005
					: LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_003;
			DataFormatException ex = new DataFormatException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_012, messageId, name, value, key,
					path));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}
	}

	/**
	 * ڂ̒lDateŐݒ肵܂B
	 * @param value ڂ̒l
	 */
	public void setDate(Date value) {
		this.value = value != null ? DateFormat.getDateInstance().format(value) : null;
	}

	/**
	 * ڂ̖OԂURI擾܂B
	 *
	 * @return ڂ̖OԂURI
	 */
	public String getURI() {
		return uri;
	}

	/**
	 * ڂ̖OԂURIݒ肵܂B
	 *
	 * @param uri ڂ̖OԂURI
	 */
	public void setURI(String uri) {
		this.uri = uri;
	}

	/**
	 * ڂQName擾܂B
	 *
	 * @return ڂQName
	 */
	public String getQName() {
		return qName;
	}

	/**
	 * ڂQNameݒ肵܂B
	 *
	 * @param qName ڂQName
	 */
	public void setQName(String qName) {
		this.qName = qName;
	}

	/**
	 * ڂ̑擾܂B
	 * @return ڂSĂ̑
	 */
	public XMLAttributes getAttributes() {
		return attributes;
	}

	/**
	 * ڂ̑ݒ肵܂B
	 * @param attributes ڂSĂ̑
	 */
	public void setAttributes(XMLAttributes attributes) {
		this.attributes = attributes;
	}

	/**
	 * ڂ̑ǉ܂B
	 * @param attribute 
	 */
	public void putAttribute(XMLAttribute attribute) {
		attributes.putAttribute(attribute);
	}

	/**
	 * ڂ̒lStringŎ擾܂B
	 * @return ڂ̒l
	 */
	public String toString() {
		return value;
	}
}
