/*
 * XMLFileReader.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFileParseException;

/**
 * XMLt@Cǂݍނ߂̃C^tF[XB
 * @author Daisuke Suga
 */
public interface XMLFileReader extends Accessor {

	/**
	 * XMLt@Cw肳ꂽpXAXMLPathԋp܂B
	 *
	 * @param path pX
	 * @return XMLPath
	 * @throws AccessorNotOpenException OpenĂȂANZbTɑ΂AsƂɔ܂B
	 */
	XMLPath selectPath(String path) throws AccessorNotOpenException;

	/**
	 * XMLt@CI[v܂B
	 *
	 * @throws AccessorAlreadyOpenedException ANZbTdOpenꂽƂɔ܂B
	 * @throws DataFileNotFoundException f[^t@C݂Ȃꍇɔ܂B
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 * @throws DataFileParseException XMLt@C͂sɔ܂B
	 */
	void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException,
			DataFileParseException, DataFileIOException;

	/**
	 * XMLt@CI[v܂B
	 *
	 * @param filepath XMLt@C̃pX
	 * @throws AccessorAlreadyOpenedException ANZbTdOpenꂽƂɔ܂B
	 * @throws DataFileNotFoundException f[^t@C݂Ȃꍇɔ܂B
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 * @throws DataFileParseException XMLt@C͂sɔ܂B
	 */
	void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException,
			DataFileParseException, DataFileIOException;

	/**
	 * XMLt@CN[Y܂B
	 *
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	void close() throws DataFileIOException;

}
