/*
 * XMLFileReaderImpl.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

import jp.co.cybec.cb3.accessor.AccessorsLifeCycle;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.ConfigFileDefinitionException;
import jp.co.cybec.cb3.exception.ConfigFileIOException;
import jp.co.cybec.cb3.exception.ConfigFileNotFoundException;
import jp.co.cybec.cb3.exception.ConfigFileParseException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;
import jp.co.cybec.cb3.exception.DataFileParseException;
import jp.co.cybec.cb3.util.ConfigurationLoader;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

/**
 * XMLt@C̓ǂݍ݃NXB
 * @author Daisuke Suga
 */
public class XMLFileReaderImpl implements XMLFileReader, AccessorsLifeCycle {

	/** O */
	private static final Log LOG = LogFactory.getLog(XMLFileReaderImpl.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * XML`t@Cdigester[̃t@CpXB
	 */
	private static final String XML_FILE_READER_RULE_FILE_NAME = "XMLFileReaderRule.xml";

	/**
	 * ANZbT̃L[B
	 */
	private String key = null;

	/**
	 * XML`t@CB
	 */
	private XMLFileReaderConfig config = null;

	/**
	 * t@C̃I[vԂێtOB
	 */
	private boolean isOpen = false;

	/**
	 * XMLt@CBufferedInputStreamB
	 */
	private BufferedInputStream stream = null;

	/**
	 * XMLt@CXmlObjectB
	 */
	private XmlObject xml = null;

	/**
	 * RXgN^B
	 */
	public XMLFileReaderImpl() {
		super();
	}

	/**
	 * {@inheritDoc}
	 */
	public XMLPath selectPath(String path) throws AccessorNotOpenException {

		// fobOO
		if (LOG.isDebugEnabled()) {
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_007, key,
					path));
		}

		// t@CI[vĂȂꍇAOX[܂B
		if (!isOpen) {
			AccessorNotOpenException ex = new AccessorNotOpenException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_013,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_001, key));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// XMLPath쐬ĕԋp܂B
		return new XMLPath(key, xml, path);

	}

	/**
	 * {@inheritDoc}
	 */
	public void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException,
			DataFileParseException, DataFileIOException {

		// łopenĂꍇAOX[܂B
		if (isOpen) {
			AccessorAlreadyOpenedException ex = new AccessorAlreadyOpenedException(MESSAGE
					.getErrorMessage(ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_014,
							LogMessageConstant.CB3_ACCESSOR_FILEACCESS_002, key));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// t@CpXݒ肳ĂȂꍇ͗OX[܂B
		if (config.getFilepath() == null || config.getFilepath().length() == 0) {
			DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_041,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_018));
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		try {

			// XMLt@CI[v܂B
			File file = new File(config.getFilepath());
			stream = new BufferedInputStream(new FileInputStream(file));
			xml = XmlObject.Factory.parse(stream);
			isOpen = true;

		} catch (FileNotFoundException e) {
			DataFileNotFoundException ex = new DataFileNotFoundException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_015,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_003, config.getFilepath()), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		} catch (IOException e) {
			DataFileIOException ex = new DataFileIOException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_016,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004, config.getFilepath()), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		} catch (XmlException e) {
			DataFileParseException ex = new DataFileParseException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_017,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_001, config.getFilepath()), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

	}

	/**
	 * {@inheritDoc}
	 */
	public void open(String filepath) throws AccessorAlreadyOpenedException,
			DataFileNotFoundException, DataFileParseException, DataFileIOException {
		config.setFilepath(filepath);
		open();
	}

	/**
	 * {@inheritDoc}
	 */
	public void close() throws DataFileIOException {

		if (isOpen) {
			try {
				stream.close();
				xml = null;
				stream = null;
				isOpen = false;
			} catch (IOException e) {
				throw new DataFileIOException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_018,
						LogMessageConstant.CB3_ACCESSOR_FILEACCESS_004, config.getFilepath()), e);
			}
		}

	}

	/**
	 * {@inheritDoc}
	 *
	 * @throws ConfigFileNotFoundException ݒt@C݂Ȃꍇɔ܂B
	 * @throws ConfigFileDefinitionException ݒt@C̊ԈႢɂ蔭܂B
	 * @throws ConfigFileIOException ݒt@CǂݍݎIOG[ɂ蔭܂B
	 * @throws ConfigFileParseException ݒt@CXMLt@C͂sɔ܂B
	 */
	public void initialize(String key) throws ConfigFileNotFoundException,
			ConfigFileDefinitionException, ConfigFileIOException, ConfigFileParseException {

		// ANZbT̃L[ێ܂B
		this.key = key;

		// keyiݒt@Cjݒt@Cǂݍ
		config = (XMLFileReaderConfig) ConfigurationLoader
				.load(XML_FILE_READER_RULE_FILE_NAME, key);

	}

	/**
	 * {@inheritDoc}
	 *
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	public void release() throws DataFileIOException {
		// XMLt@CN[Y܂B
		close();
	}

}
