/*
 * XMLFileWriter.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import jp.co.cybec.cb3.accessor.Accessor;
import jp.co.cybec.cb3.exception.AccessorAlreadyOpenedException;
import jp.co.cybec.cb3.exception.AccessorNotOpenException;
import jp.co.cybec.cb3.exception.BadXmlGrammerException;
import jp.co.cybec.cb3.exception.DataFileIOException;
import jp.co.cybec.cb3.exception.DataFileNotFoundException;

/**
 * XMLt@Cނ߂̃C^tF[XB
 * @author Daisuke Suga
 */
public interface XMLFileWriter extends Accessor {

	/**
	 * XML̗vf̊Jn^Oo͂܂B
	 *
	 * @param element vf
	 * @throws AccessorNotOpenException OpenĂȂANZbTɑ΂AsƂɔ܂B
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	void startElement(XMLElement element) throws AccessorNotOpenException, DataFileIOException;

	/**
	 * XML̗vf̏I^Oo͂܂B
	 *
	 * @param element vf
	 * @throws AccessorNotOpenException OpenĂȂANZbTɑ΂AsƂɔ܂B
	 * @throws BadXmlGrammerException XML̕@ԈĂƂɔ܂B
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	void endElement(XMLElement element) throws AccessorNotOpenException, BadXmlGrammerException,
			DataFileIOException;

	/**
	 * XML̗vf݂܂B<br>
	 * startElementcharactersAendElements܂B
	 *
	 * @param element vf
	 * @throws AccessorNotOpenException OpenĂȂANZbTɑ΂AsƂɔ܂B
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	void dataElement(XMLElement element) throws AccessorNotOpenException, DataFileIOException;

	/**
	 * XML̗vf̒l݂܂B
	 *
	 * @param element vf
	 * @throws AccessorNotOpenException OpenĂȂANZbTɑ΂AsƂɔ܂B
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	void characters(XMLElement element) throws AccessorNotOpenException, DataFileIOException;

	/**
	 * OԂ̒`ǉ܂B
	 *
	 * @param uri OԂURI
	 * @param prefix ړ
	 * @throws AccessorNotOpenException OpenĂȂANZbTɑ΂AsƂɔ܂B
	 */
	void addNamespace(String uri, String prefix) throws AccessorNotOpenException;

	/**
	 * OԂ̒`ǉ܂B
	 *
	 * @param uri OԂURI
	 * @throws AccessorNotOpenException OpenĂȂANZbTɑ΂AsƂɔ܂B
	 */
	void addNamespace(String uri) throws AccessorNotOpenException;

	/**
	 * XMLt@CI[v܂B
	 *
	 * @throws AccessorAlreadyOpenedException ANZbTdOpenꂽƂɔ܂B
	 * @throws DataFileNotFoundException f[^t@C݂Ȃꍇɔ܂B
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	void open() throws AccessorAlreadyOpenedException, DataFileNotFoundException,
			DataFileIOException;

	/**
	 * XMLt@CI[v܂B
	 *
	 * @param filepath XMLt@C̃pX
	 * @throws AccessorAlreadyOpenedException ANZbTdOpenꂽƂɔ܂B
	 * @throws DataFileNotFoundException f[^t@C݂Ȃꍇɔ܂B
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	void open(String filepath) throws AccessorAlreadyOpenedException, DataFileNotFoundException,
			DataFileIOException;

	/**
	 * XMLt@CN[Y܂B
	 *
	 * @throws DataFileIOException f[^t@CǂݏIOG[ɂ蔭܂B
	 */
	void close() throws DataFileIOException;

}
