/*
 * XMLPath.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.accessor.fileaccess.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.co.cybec.cb3.exception.AccessorUnknownException;
import jp.co.cybec.cb3.exception.BadXmlGrammerException;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;

/**
 * XMLt@CXPath\NXB
 * @author Daisuke Suga
 */
public class XMLPath {

	/** O */
	private static final Log LOG = LogFactory.getLog(XMLPath.class);

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * ANZbT̃L[B
	 */
	private String key = null;

	/**
	 * pXB
	 */
	private String path = null;

	/**
	 * XMLt@CXmlCursorB
	 */
	private XmlCursor cursor = null;

	/**
	 * selectChildPathŌqXmlCursorێ郊XgB
	 */
	private List<XmlCursor> childCursorList = new ArrayList<XmlCursor>();

	/** ̍sԍ */
	private int row = 0;

	/**
	 * RXgN^B
	 */
	protected XMLPath() {
		super();
	}

	/**
	 * RXgN^B<br>
	 * XMLt@CXmlCursor쐬Aw肳ꂽpXŌ܂B
	 *
	 * @param key ANZbT̃L[
	 * @param xml XmlObject
	 * @param path pX
	 * @throws BadXmlGrammerException XML̕@ԈĂƂɔ܂B
	 * @throws AccessorUnknownException ANZbTŕs̃G[Ƃɔ܂B
	 */
	protected XMLPath(String key, XmlObject xml, String path) throws BadXmlGrammerException,
			AccessorUnknownException {

		// ANZbT̃L[ێ܂B
		this.key = key;

		// pXێ܂B
		this.path = path;

		// VJ[\쐬܂B
		try {
			cursor = xml.newCursor();
		} catch (Exception e) {
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_036,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_006, key), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// w肳ꂽpXŌ܂B
		try {
			cursor.selectPath(path);
		} catch (Exception e) {
			BadXmlGrammerException ex = new BadXmlGrammerException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_037,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_002, key, path), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

	}

	/**
	 * RXgN^B<br>
	 * w肳ꂽXmlCursorŏ܂B
	 *
	 * @param key ANZbT̃L[
	 * @param cursor XmlCursor
	 * @param path pX
	 */
	protected XMLPath(String key, XmlCursor cursor, String path) {

		// ANZbT̃L[ێ܂B
		this.key = key;

		// pXێ܂B
		this.path = path;

		// J[\ݒ肵܂B
		this.cursor = cursor;
	}

	/**
	 * XMLElement擾܂B<br>
	 * 擾XMLElementȂꍇnullԂ܂B
	 *
	 * @return XMLElement
	 * @throws AccessorUnknownException ANZbTŕs̃G[Ƃɔ܂B
	 */
	public XMLElement next() throws AccessorUnknownException {

		try {

			// sԍCNgB
			row++;

			// q̌sĂꍇ́AׂĂ̎q̃J[\N[Y܂B
			for (XmlCursor childCursor : childCursorList) {
				childCursor.dispose();
			}
			childCursorList.clear();

			// XMLElementȂꍇnullԂ܂B
			if (!cursor.hasNextSelection()) {
				return null;
			}

			cursor.toNextSelection();
			cursor.push();

			XMLElement element = new XMLElement(cursor.getName().getLocalPart(), key, path);

			// lݒ肵܂B
			element.setString(cursor.getTextValue());

			// ̒lݒ肵܂B
			if (cursor.toFirstAttribute()) {
				do {
					String name = cursor.getName().getLocalPart();
					element.putAttribute(new XMLAttribute(name, cursor.getTextValue(), element
							.getName(), key, path));
				} while (cursor.toNextAttribute());
			}

			cursor.pop();

			// fobOO
			if (LOG.isDebugEnabled()) {
				StringBuilder elementMessage = new StringBuilder();
				elementMessage.append(element.getName());
				elementMessage.append("=");
				elementMessage.append(element.getString());

				StringBuilder attributeMessage = new StringBuilder();
				int index = 0;
				for (Map.Entry<String, XMLAttribute> entry : element.getAttributes().entrySet()) {
					index++;
					if (index > 1) {
						attributeMessage.append(", ");
					}
					attributeMessage.append(entry.getKey());
					attributeMessage.append("=");
					attributeMessage.append(entry.getValue().getString());
				}
				LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_008,
						key, path, row, elementMessage.toString(), attributeMessage.toString()));
			}

			return element;

		} catch (Exception e) {
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_038,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_006, key), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

	}

	/**
	 * ݂̃m[hw肳ꂽq̃pXAXMLPathԋp܂B
	 *
	 * @param path pX
	 * @return XMLPath
	 * @throws BadXmlGrammerException XML̕@ԈĂƂɔ܂B
	 * @throws AccessorUnknownException ANZbTŕs̃G[Ƃɔ܂B
	 */
	public XMLPath selectChildPath(String path) throws BadXmlGrammerException,
			AccessorUnknownException {

		// fobOO
		if (LOG.isDebugEnabled()) {
			LOG.debug(MESSAGE.getMessage(LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_007, key,
					path));
		}

		// VJ[\쐬܂B
		XmlCursor childCursor = null;
		try {
			childCursor = cursor.newCursor();
		} catch (Exception e) {
			AccessorUnknownException ex = new AccessorUnknownException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_039,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_006, key), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		// q̃pX܂B
		try {
			childCursor.selectPath(path);
		} catch (Exception e) {
			BadXmlGrammerException ex = new BadXmlGrammerException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.ACCESSOR_FILEACCESS_XML_040,
					LogMessageConstant.CB3_ACCESSOR_FILEACCESS_XML_002, key, path), e);
			LOG.info(ex.getMessage(), ex);
			throw ex;
		}

		childCursorList.add(childCursor);
		return new XMLPath(key, childCursor, path);

	}

}
