/*
 * ServiceProviderFactory.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.container.provider;

import jp.co.cybec.cb3.exception.ServiceProviderCreationException;
import jp.co.cybec.cb3.util.CB3BeanFactory;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

/**
 * T[rXvoC_t@NgNXB
 * @author Naoko Sugimoto
 */
public class ServiceProviderFactory {
	/** T[rXvoC_t@Ng */
	private static ServiceProviderFactory factory = new ServiceProviderFactory();

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * T[rXvoC_t@Ng擾܂B
	 * @return T[rXt@Ng
	 */
	public static ServiceProviderFactory getInstance() {
		return factory;
	}

	/**
	 * RXgN^B
	 */
	private ServiceProviderFactory() {
	}

	/**
	 * T[rXvoC_擾܂B
	 *
	 * @param beanId T[rXvoC_bean idB
	 * @return T[rXvoC_B
	 */
	public ServiceProvider getServiceProvider(String beanId) {
		CB3BeanFactory beanFactory = CB3BeanFactory.getInstance();
		try {
			// Beant@NgT[rXvoC_擾B
			return (ServiceProvider)beanFactory.getBean(beanId);

		} catch (RuntimeException e) {
			Object[] param = {
					beanFactory.getApplicationContextFilePath(),
					beanId
			};
			throw new ServiceProviderCreationException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.CONTAINER_PROVIDER_001,
					LogMessageConstant.CB3_CONTAINER_PROVIDER_002, param), e);
		}

	}
}
