/*
 * ServiceProviderImpl.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.container.provider;

import java.text.SimpleDateFormat;
import java.util.Date;

import jp.co.cybec.cb3.container.service.Service;
import jp.co.cybec.cb3.exception.RuntimeArgumentsAnalyzeException;
import jp.co.cybec.cb3.session.RuntimeArgumentsAnalyzer;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import jp.co.cybec.cb3.util.ApplicationExiterDelegater;
import jp.co.cybec.cb3.util.ExitCodeConstant;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;
import jp.co.cybec.cb3.util.logging.LogMessageIdentifier;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * T[rXvoC_̎NXB
 * @author Naoko Sugimoto
 */
public class ServiceProviderImpl implements ServiceProvider {

	/** O */
	private static final Log LOG = LogFactory.getLog(ServiceProviderImpl.class);

	/** Np[^Ɏw肷T[rX̃L[ */
	private static final String SERVICE_KEY = "-ServiceName";

	/** T[rX */
	private Service service = null;

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * T[rXP̂ŎsꍇɎgpAN\bhłB<br>
	 * mainN̈ɁAserviceContext.xmlŒ`T[rXvoC_bean id
	 * w肷Kv܂B<br>
	 * w@F -ServiceName [bean id]<br>
	 * <pre>
	 * FR\[>java () xxx.ServiceProviderImpl -ServiceName sample
	 * </pre>
	 * ܂AT[rXɔCӂ̃p[^nƂł܂B<br>
	 * w@F -AppParams key1=value1 key2=value2 key3=value3 ...<br>
	 * <pre>
	 * FR\[>java () xxx.ServiceProviderImpl -ServiceName sample -AppParams key1=value1 key2=value2 ...
	 * </pre>
	 * u-AppParamsvȍ~Ɏw肳ꂽp[^(key1=value1 key2=value2 ...){@link RuntimeParameters}Ɋi[A
	 * T[rXɈn܂B<br>
	 * u-AppParamsv́Au-ServiceNamevɋLqKv܂B
	 * @param args Np[^
	 */
	public static void main(String[] args) {

		try {
			// ͂Ap[^擾B
			RuntimeArgumentsAnalyzer analyzer = analyzeArguments(args);

			// T[rXbeanId擾B
			String beanId = analyzer.getReservedParameter(SERVICE_KEY);

			// ObZ[Wʎqݒ肷B
			SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
			LogMessageIdentifier.setJobProcessId(beanId + sdf.format(new Date()));
			LogMessageIdentifier.setServiceId(beanId);

			// T[rX`t@Cǂݍ݁ADIgpăT[rXvoC_𐶐B
			ServiceProvider provider = (ServiceProvider)ServiceProviderFactory.getInstance().getServiceProvider(beanId);

			// T[rXsB
			int resultCode = provider.callService(new ServiceParameters(), analyzer.getRuntimeParameters());

			ApplicationExiterDelegater.getInstance().exit(resultCode);
		} catch (Throwable t) {
			// G[̏ꍇÃwv\B
			if (t instanceof RuntimeArgumentsAnalyzeException) {
				String helpMessage = "ServiceProviderImpl [-ServiceName T[rXvoC_beanid] [-AppParam L[=l L[=l ...]";
				LOG.error(MESSAGE.getErrorMessage(ErrorCodeConstant.CONTAINER_PROVIDER_002,
						LogMessageConstant.CB3_CONTAINER_PROVIDER_003, helpMessage));
			}

			// G[xŃOóB
			LOG.error(t.getMessage(), t);
			// ُIB
			ApplicationExiterDelegater.getInstance().exit(ExitCodeConstant.ERROR);
		}
	}

	/**
	 * mainN̈͂Ap[^擾܂B
	 * @param args mainN̈
	 * @return ͌ʂێAiCU
	 */
	private static RuntimeArgumentsAnalyzer analyzeArguments(String[] args) {

		// ͂Ap[^擾B
		RuntimeArgumentsAnalyzer analyzer = new RuntimeArgumentsAnalyzer(args, SERVICE_KEY);

		// ɎsT[rXw肳Ă邱Ƃ`FbNB
		if (analyzer.getReservedParameter(SERVICE_KEY) == null) {
			throw new RuntimeArgumentsAnalyzeException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.CONTAINER_PROVIDER_003,
					LogMessageConstant.CB3_CONTAINER_PROVIDER_001, SERVICE_KEY));
		}

		return analyzer;
	}

	/**
	 * T[rXZbg܂B
	 * @param service T[rXB
	 */
	public void setService(Service service) {
		this.service = service;
	}

	/**
	 * T[rXs܂B
	 * @param serviceParameters T[rXp[^B
	 * @param runtimeParameters Np[^B
	 * @return sʁB
	 */
	public int callService(
			ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) {

		// ƖsB
		return service.callService(serviceParameters, runtimeParameters);
	}

}
