/*
 * CB3Service.java
 * Copyright (C) 2008 Cyber Beans Corporation. All rights reserved.
 */
package jp.co.cybec.cb3.container.service;

import jp.co.cybec.cb3.accessor.DataAccessContext;
import jp.co.cybec.cb3.accessor.DataAccessContextLifeCycle;
import jp.co.cybec.cb3.exception.ServiceException;
import jp.co.cybec.cb3.exception.ServiceExecutionException;
import jp.co.cybec.cb3.session.RuntimeParameters;
import jp.co.cybec.cb3.session.ServiceParameters;
import jp.co.cybec.cb3.util.logging.ErrorCodeConstant;
import jp.co.cybec.cb3.util.logging.LogMessageConstant;
import jp.co.cybec.cb3.util.logging.LogMessageFactory;

/**
 * T[rXNXB<br>
 * T[rX̃ev[g񋟂܂B
 * T[rXNX쐬́ÃNXp܂B
 * @author Naoko Sugimoto
 */
public abstract class CB3Service implements Service {

	/** f[^ANZXReLXg */
	private DataAccessContext dataAccessContext = null;

	/** bZ[W */
	private static final LogMessageFactory MESSAGE = new LogMessageFactory(
			LogMessageConstant.CB3_MESSAGE_FILENAME);

	/**
	 * f[^ANZXReLXgݒ肵܂B
	 * @param dataAccessContext f[^ANZXReLXg
	 */
	public void setDataAccessContext(DataAccessContext dataAccessContext) {
		this.dataAccessContext = dataAccessContext;
	}

	/**
	 * f[^ANZXReLXgԂ܂B
	 * @return f[^ANZXReLXg
	 */
	public DataAccessContext getDataAccessContext() {
		return dataAccessContext;
	}

	/**
	 * T[rXs܂B
	 * @param serviceParameters T[rXp[^
	 * @param runtimeParameters Np[^
	 * @return s
	 */
	public int callService(
			ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) {
		try {
			// ƖsB
			return doService(serviceParameters, runtimeParameters);
		} catch (Exception e) {
			throw new ServiceExecutionException(MESSAGE.getErrorMessage(
					ErrorCodeConstant.CONTAINER_SERVICE_001,
					LogMessageConstant.CB3_CONTAINER_SERVICE_001), e);
		} finally {
			try {
				// f[^ANZXReLXg̏IB
				if (dataAccessContext != null) {
					((DataAccessContextLifeCycle)getDataAccessContext()).release();
				}
			} catch (Exception e) {
				throw new ServiceExecutionException(MESSAGE.getErrorMessage(
						ErrorCodeConstant.CONTAINER_SERVICE_002,
						LogMessageConstant.CB3_CONTAINER_SERVICE_002), e);
			}
		}
	}

	/**
	 * ƖLq郁\bhłB<br>
	 * T[rXNXł́Ã\bhI[o[ChAƖLq܂B<br>
	 * ̃\bhɂ́A{@link ServiceParameters}A{@link RuntimeParameters}Ƃēn܂B<br>
	 * <br>
	 * <strong>EServiceParameters̎gp@</strong><br>
	 * ServiceParameterśAT[rXԂ̃p[^󂯓nɎgpł܂B<br>
	 * ServiceParameters̓WułPłAT[rXŃZbgp[^́A
	 * ̃T[rXɈƂēnꂽServiceParameters擾ł܂B<br>
	 * {@link ServiceParameters#put(String, Serializable)}Ɏw肷T[rXp[^L[
	 * WuňӂłKv܂B<br>
	 * <br>
	 * ʏA{@link ServiceParameters#put(String, Serializable)}̈
	 * R[hPʂ̃f[^Zbg邱Ƃ͑z肳Ă܂B<br>
	 * <br>
	 * <table>
	 * <tr><td></td><td>z肳ȂgpF</td></tr>
	 * <tr><td></td><td>T[rXp[^L[ = [UIDi"0001"Ȃǁj</td></tr>
	 * <tr><td></td><td>T[rXp[^ = [Ui"Naoko Sugimoto"Ȃǁj</td></tr>
	 * </table>
	 * <br>
	 * WuňӐĂPʂŃT[rXp[^L[`ĂB<br>
	 * <br>
	 * <table>
	 * <tr><td></td><td>gpF</td></tr>
	 * <tr><td></td><td>T[rXp[^L[ = e[u</td></tr>
	 * <tr><td></td><td>T[rXp[^ = e[u\IuWFNg</td></tr>
	 * </table>
	 * <br>
	 * <strong>ERuntimeParameters̎gp@</strong><br>
	 * RuntimeParametersɂ́AAvP[VNɓnꂽi[Ă܂B<br>
	 * <br>
	 * <pre>
	 * FR\[>java () xxx.ServiceProviderImpl -ServiceName sample -AppParams key1=value1 key2=value2 ...
	 * </pre>
	 * NɏL̂悤Ȉw肳ꂽꍇA-AppParamsȍ~RuntimeParametersɊi[A
	 * {@link RuntimeParameters#get(String)}gpĎ擾邱Ƃł܂B
	 * <pre>
	 * runtimeParameters.get("key1")  "value1"
	 * runtimeParameters.get("key2")  "value2"
	 *  c
	 * </pre>
	 *
	 * @param serviceParameters T[rXp[^
	 * @param runtimeParameters Np[^
	 * @return s
	 * @throws ServiceException Ɩŉ炩̗OꍇB
	 */
	protected abstract int doService(
			ServiceParameters serviceParameters, RuntimeParameters runtimeParameters) throws ServiceException;
}
